/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class IteratingActionListener<T, U>
implements ActionListener<T>,
Runnable {
    private final List<U> consumables;
    private final ActionListener<T> delegate;
    private final BiConsumer<U, ActionListener<T>> consumer;
    private final ThreadContext threadContext;
    private final Supplier<T> consumablesFinishedResponse;
    private int position = 0;

    public IteratingActionListener(ActionListener<T> delegate, BiConsumer<U, ActionListener<T>> consumer, List<U> consumables, ThreadContext threadContext) {
        this(delegate, consumer, consumables, threadContext, null);
    }

    public IteratingActionListener(ActionListener<T> delegate, BiConsumer<U, ActionListener<T>> consumer, List<U> consumables, ThreadContext threadContext, @Nullable Supplier<T> consumablesFinishedResponse) {
        this.delegate = delegate;
        this.consumer = consumer;
        this.consumables = Collections.unmodifiableList(consumables);
        this.threadContext = threadContext;
        this.consumablesFinishedResponse = consumablesFinishedResponse;
    }

    @Override
    public void run() {
        if (this.consumables.isEmpty()) {
            this.onResponse((T)null);
        } else if (this.position < 0 || this.position >= this.consumables.size()) {
            this.onFailure(new IllegalStateException("invalid position [" + this.position + "]. List size [" + this.consumables.size() + "]"));
        } else {
            try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(false);){
                this.consumer.accept((IteratingActionListener)this.consumables.get(this.position++), this);
            }
        }
    }

    @Override
    public void onResponse(T response) {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(false);){
            if (response == null) {
                if (this.position == this.consumables.size()) {
                    if (this.consumablesFinishedResponse != null) {
                        this.delegate.onResponse(this.consumablesFinishedResponse.get());
                    } else {
                        this.delegate.onResponse(null);
                    }
                } else {
                    this.consumer.accept((IteratingActionListener)this.consumables.get(this.position++), this);
                }
            } else {
                this.delegate.onResponse(response);
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(false);){
            this.delegate.onFailure(e);
        }
    }
}

