/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.io.netty.util.ThreadDeathWatcher;
import org.elasticsearch.io.netty.util.concurrent.GlobalEventExecutor;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.XPackPlugin;

public class PreBuiltXPackTransportClient
extends PreBuiltTransportClient {
    @SafeVarargs
    public PreBuiltXPackTransportClient(Settings settings, Class<? extends Plugin> ... plugins) {
        this(settings, Arrays.asList(plugins));
    }

    public PreBuiltXPackTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        this(settings, plugins, null);
    }

    public PreBuiltXPackTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins, TransportClient.HostFailureListener hostFailureListener) {
        super(settings, PreBuiltXPackTransportClient.addPlugins(plugins, Collections.singletonList(XPackPlugin.class)), hostFailureListener);
    }

    @Override
    public void close() {
        super.close();
        if (NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings).equals("security4")) {
            try {
                GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                ThreadDeathWatcher.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

