/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.suggest.Suggest;

public final class CompletionSuggestion
extends Suggest.Suggestion<Entry> {
    public static final int TYPE = 4;

    public CompletionSuggestion() {
    }

    public CompletionSuggestion(String name, int size) {
        super(name, size);
    }

    public List<Entry.Option> getOptions() {
        if (!this.entries.isEmpty()) {
            assert (this.entries.size() == 1) : "CompletionSuggestion must have only one entry";
            return ((Entry)this.entries.get(0)).getOptions();
        }
        return Collections.emptyList();
    }

    public boolean hasScoreDocs() {
        return this.getOptions().size() > 0;
    }

    public static CompletionSuggestion reduceTo(List<Suggest.Suggestion<Entry>> toReduce) {
        if (toReduce.isEmpty()) {
            return null;
        }
        CompletionSuggestion leader = (CompletionSuggestion)toReduce.get(0);
        Entry leaderEntry = (Entry)leader.getEntries().get(0);
        String name = leader.getName();
        if (toReduce.size() == 1) {
            return leader;
        }
        OptionPriorityQueue priorityQueue = new OptionPriorityQueue(leader.getSize(), Suggest.COMPARATOR);
        for (Suggest.Suggestion<Entry> suggestion : toReduce) {
            assert (suggestion.getName().equals(name)) : "name should be identical across all suggestions";
            for (Entry.Option option : ((CompletionSuggestion)suggestion).getOptions()) {
                if (option == priorityQueue.insertWithOverflow(option)) break;
            }
        }
        CompletionSuggestion suggestion = new CompletionSuggestion(leader.getName(), leader.getSize());
        Entry entry = new Entry(leaderEntry.getText(), leaderEntry.getOffset(), leaderEntry.getLength());
        Collections.addAll(entry.getOptions(), priorityQueue.get());
        suggestion.addTerm(entry);
        return suggestion;
    }

    @Override
    public Suggest.Suggestion<Entry> reduce(List<Suggest.Suggestion<Entry>> toReduce) {
        return CompletionSuggestion.reduceTo(toReduce);
    }

    public void setShardIndex(int shardIndex) {
        if (!this.entries.isEmpty()) {
            for (Entry.Option option : this.getOptions()) {
                option.setShardIndex(shardIndex);
            }
        }
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static final class Entry
    extends Suggest.Suggestion.Entry<Option> {
        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        protected Entry() {
        }

        @Override
        protected Option newOption() {
            return new Option();
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private Map<String, Set<CharSequence>> contexts;
            private ScoreDoc doc;
            private InternalSearchHit hit;

            public Option(int docID, Text text, float score, Map<String, Set<CharSequence>> contexts) {
                super(text, score);
                this.doc = new ScoreDoc(docID, score);
                this.contexts = contexts;
            }

            protected Option() {
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                throw new UnsupportedOperationException();
            }

            public Map<String, Set<CharSequence>> getContexts() {
                return this.contexts;
            }

            public ScoreDoc getDoc() {
                return this.doc;
            }

            public InternalSearchHit getHit() {
                return this.hit;
            }

            public void setShardIndex(int shardIndex) {
                this.doc.shardIndex = shardIndex;
            }

            public void setHit(InternalSearchHit hit) {
                this.hit = hit;
            }

            @Override
            protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field("text", this.getText());
                if (this.hit != null) {
                    this.hit.toInnerXContent(builder, params);
                } else {
                    builder.field("score", this.getScore());
                }
                if (this.contexts.size() > 0) {
                    builder.startObject("contexts");
                    for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                        builder.startArray(entry.getKey());
                        for (CharSequence context : entry.getValue()) {
                            builder.value(context.toString());
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                return builder;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                super.readFrom(in);
                this.doc = Lucene.readScoreDoc(in);
                if (in.readBoolean()) {
                    this.hit = InternalSearchHit.readSearchHit(in);
                }
                int contextSize = in.readInt();
                this.contexts = new LinkedHashMap<String, Set<CharSequence>>(contextSize);
                for (int i = 0; i < contextSize; ++i) {
                    String contextName = in.readString();
                    int nContexts = in.readVInt();
                    HashSet<String> contexts = new HashSet<String>(nContexts);
                    for (int j = 0; j < nContexts; ++j) {
                        contexts.add(in.readString());
                    }
                    this.contexts.put(contextName, contexts);
                }
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                Lucene.writeScoreDoc(out, this.doc);
                if (this.hit != null) {
                    out.writeBoolean(true);
                    this.hit.writeTo(out);
                } else {
                    out.writeBoolean(false);
                }
                out.writeInt(this.contexts.size());
                for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                    out.writeString(entry.getKey());
                    out.writeVInt(entry.getValue().size());
                    for (CharSequence ctx : entry.getValue()) {
                        out.writeString(ctx.toString());
                    }
                }
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("text:");
                stringBuilder.append(this.getText());
                stringBuilder.append(" score:");
                stringBuilder.append(this.getScore());
                stringBuilder.append(" context:[");
                for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        }
    }

    private static final class OptionPriorityQueue
    extends PriorityQueue<Entry.Option> {
        private final Comparator<Suggest.Suggestion.Entry.Option> comparator;

        OptionPriorityQueue(int maxSize, Comparator<Suggest.Suggestion.Entry.Option> comparator) {
            super(maxSize);
            this.comparator = comparator;
        }

        @Override
        protected boolean lessThan(Entry.Option a, Entry.Option b) {
            int cmp = this.comparator.compare(a, b);
            if (cmp != 0) {
                return cmp > 0;
            }
            return Lookup.CHARSEQUENCE_COMPARATOR.compare(a.getText().string(), b.getText().string()) > 0;
        }

        Entry.Option[] get() {
            int size = this.size();
            Entry.Option[] results = new Entry.Option[size];
            for (int i = size - 1; i >= 0; --i) {
                results[i] = (Entry.Option)this.pop();
            }
            return results;
        }
    }
}

