/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum SortBy implements Writeable
{
    SCORE,
    FREQUENCY;


    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static SortBy readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= SortBy.values().length) {
            throw new IOException("Unknown SortBy ordinal [" + ordinal + "]");
        }
        return SortBy.values()[ordinal];
    }

    public static SortBy resolve(String str) {
        Objects.requireNonNull(str, "Input string is null");
        return SortBy.valueOf(str.toUpperCase(Locale.ROOT));
    }
}

