/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.slice;

import com.carrotsearch.hppc.BitMixer;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.slice.SliceQuery;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesSliceQuery.this.getField());
                return new Bits(){

                    @Override
                    public boolean get(int doc) {
                        values.setDocument(doc);
                        int i = 0;
                        if (i < values.count()) {
                            return DocValuesSliceQuery.this.contains(BitMixer.mix(values.valueAt(i)));
                        }
                        return DocValuesSliceQuery.this.contains(0L);
                    }

                    @Override
                    public int length() {
                        return context.reader().maxDoc();
                    }
                };
            }
        };
    }
}

