/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Snippet;
import org.apache.lucene.search.postingshighlight.CustomSeparatorBreakIterator;
import org.apache.lucene.search.uhighlight.CustomPassageFormatter;
import org.apache.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.elasticsearch.search.fetch.subphase.highlight.PostingsHighlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class UnifiedHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-unified";

    @Override
    public boolean canHighlight(FieldMapper fieldMapper) {
        return true;
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        FieldMapper fieldMapper = highlighterContext.mapper;
        SearchContextHighlight.Field field = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            hitContext.cache().put(CACHE_KEY, new HighlighterEntry());
        }
        HighlighterEntry highlighterEntry = (HighlighterEntry)hitContext.cache().get(CACHE_KEY);
        MapperHighlighterEntry mapperHighlighterEntry = highlighterEntry.mappers.get(fieldMapper);
        if (mapperHighlighterEntry == null) {
            Encoder encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
            CustomPassageFormatter passageFormatter = new CustomPassageFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0], encoder);
            mapperHighlighterEntry = new MapperHighlighterEntry(passageFormatter);
        }
        List<Snippet> snippets = new ArrayList<Snippet>();
        try {
            Snippet[] fieldSnippets;
            int numberOfFragments;
            CustomUnifiedHighlighter highlighter;
            String fieldValue;
            Analyzer analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
            List<Object> fieldValues = HighlightUtils.loadFieldValues(field, fieldMapper, context, hitContext);
            fieldValues = fieldValues.stream().map(obj -> {
                if (obj instanceof BytesRef) {
                    return fieldMapper.fieldType().valueForDisplay(obj).toString();
                }
                return obj;
            }).collect(Collectors.toList());
            IndexSearcher searcher = new IndexSearcher(hitContext.reader());
            if (field.fieldOptions().numberOfFragments() == 0) {
                fieldValue = PostingsHighlighter.mergeFieldValues(fieldValues, '\u0000');
                CustomSeparatorBreakIterator breakIterator = new CustomSeparatorBreakIterator('\u0000');
                highlighter = new CustomUnifiedHighlighter(searcher, analyzer, mapperHighlighterEntry.passageFormatter, breakIterator, fieldValue, field.fieldOptions().noMatchSize() > 0);
                numberOfFragments = fieldValues.size();
            } else {
                fieldValue = PostingsHighlighter.mergeFieldValues(fieldValues, '\u2029');
                highlighter = new CustomUnifiedHighlighter(searcher, analyzer, mapperHighlighterEntry.passageFormatter, null, fieldValue, field.fieldOptions().noMatchSize() > 0);
                numberOfFragments = field.fieldOptions().numberOfFragments();
            }
            if (field.fieldOptions().requireFieldMatch().booleanValue()) {
                String fieldName = highlighterContext.fieldName;
                highlighter.setFieldMatcher(name -> fieldName.equals(name));
            } else {
                highlighter.setFieldMatcher(name -> true);
            }
            for (Snippet fieldSnippet : fieldSnippets = highlighter.highlightField(highlighterContext.fieldName, highlighterContext.query, hitContext.docId(), numberOfFragments)) {
                if (!Strings.hasText(fieldSnippet.getText())) continue;
                snippets.add(fieldSnippet);
            }
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        snippets = PostingsHighlighter.filterSnippets(snippets, field.fieldOptions().numberOfFragments());
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, (o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = snippets.get(i).getText();
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
        }
        return null;
    }

    static class MapperHighlighterEntry {
        final CustomPassageFormatter passageFormatter;

        private MapperHighlighterEntry(CustomPassageFormatter passageFormatter) {
            this.passageFormatter = passageFormatter;
        }
    }

    static class HighlighterEntry {
        Map<FieldMapper, MapperHighlighterEntry> mappers = new HashMap<FieldMapper, MapperHighlighterEntry>();

        HighlighterEntry() {
        }
    }
}

