/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.collapse;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.internal.SearchContext;

public class CollapseBuilder
extends ToXContentToBytes
implements Writeable {
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    public static final ParseField MAX_CONCURRENT_GROUP_REQUESTS_FIELD = new ParseField("max_concurrent_group_searches", new String[0]);
    private static final ObjectParser<CollapseBuilder, QueryParseContext> PARSER = new ObjectParser("collapse", CollapseBuilder::new);
    private String field;
    private InnerHitBuilder innerHit;
    private int maxConcurrentGroupRequests = 0;

    private CollapseBuilder() {
    }

    public CollapseBuilder(String field) {
        Objects.requireNonNull(field, "field must be non-null");
        this.field = field;
    }

    public CollapseBuilder(StreamInput in) throws IOException {
        this.field = in.readString();
        this.maxConcurrentGroupRequests = in.readVInt();
        this.innerHit = in.readOptionalWriteable(InnerHitBuilder::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeVInt(this.maxConcurrentGroupRequests);
        out.writeOptionalWriteable(this.innerHit);
    }

    public static CollapseBuilder fromXContent(QueryParseContext context) throws IOException {
        CollapseBuilder builder = PARSER.parse(context.parser(), new CollapseBuilder(), context);
        return builder;
    }

    private CollapseBuilder setField(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public CollapseBuilder setInnerHits(InnerHitBuilder innerHit) {
        this.innerHit = innerHit;
        return this;
    }

    public CollapseBuilder setMaxConcurrentGroupRequests(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("maxConcurrentGroupRequests` must be positive");
        }
        this.maxConcurrentGroupRequests = num;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public InnerHitBuilder getInnerHit() {
        return this.innerHit;
    }

    public int getMaxConcurrentGroupRequests() {
        return this.maxConcurrentGroupRequests;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    private void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        if (this.maxConcurrentGroupRequests > 0) {
            builder.field(MAX_CONCURRENT_GROUP_REQUESTS_FIELD.getPreferredName(), this.maxConcurrentGroupRequests);
        }
        if (this.innerHit != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHit);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollapseBuilder that = (CollapseBuilder)o;
        if (this.maxConcurrentGroupRequests != that.maxConcurrentGroupRequests) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.innerHit != null ? this.innerHit.equals(that.innerHit) : that.innerHit == null;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + (this.innerHit != null ? this.innerHit.hashCode() : 0);
        result = 31 * result + this.maxConcurrentGroupRequests;
        return result;
    }

    public CollapseContext build(SearchContext context) {
        if (context.scrollContext() != null) {
            throw new SearchContextException(context, "cannot use `collapse` in a scroll context");
        }
        if (context.searchAfter() != null) {
            throw new SearchContextException(context, "cannot use `collapse` in conjunction with `search_after`");
        }
        if (context.rescore() != null && !context.rescore().isEmpty()) {
            throw new SearchContextException(context, "cannot use `collapse` in conjunction with `rescore`");
        }
        MappedFieldType fieldType = context.getQueryShardContext().fieldMapper(this.field);
        if (fieldType == null) {
            throw new SearchContextException(context, "no mapping found for `" + this.field + "` in order to collapse on");
        }
        if (!(fieldType instanceof KeywordFieldMapper.KeywordFieldType) && !(fieldType instanceof NumberFieldMapper.NumberFieldType)) {
            throw new SearchContextException(context, "unknown type for collapse field `" + this.field + "`, only keywords and numbers are accepted");
        }
        if (!fieldType.hasDocValues()) {
            throw new SearchContextException(context, "cannot collapse on field `" + this.field + "` without `doc_values`");
        }
        if (fieldType.indexOptions() == IndexOptions.NONE && this.innerHit != null) {
            throw new SearchContextException(context, "cannot expand `inner_hits` for collapse field `" + this.field + "`, only indexed field can retrieve `inner_hits`");
        }
        return new CollapseContext(fieldType, this.innerHit);
    }

    static {
        PARSER.declareString(CollapseBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(CollapseBuilder::setMaxConcurrentGroupRequests, MAX_CONCURRENT_GROUP_REQUESTS_FIELD);
        PARSER.declareObject(CollapseBuilder::setInnerHits, (p, c) -> InnerHitBuilder.fromXContent(c), INNER_HITS_FIELD);
    }
}

