/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.log4j.core.jackson;

import org.elasticsearch.jackson.databind.JsonDeserializer;
import org.elasticsearch.jackson.databind.Module;
import org.elasticsearch.jackson.databind.module.SimpleModule;
import org.elasticsearch.log4j.Level;
import org.elasticsearch.log4j.Marker;
import org.elasticsearch.log4j.ThreadContext;
import org.elasticsearch.log4j.core.LogEvent;
import org.elasticsearch.log4j.core.impl.ExtendedStackTraceElement;
import org.elasticsearch.log4j.core.impl.ThrowableProxy;
import org.elasticsearch.log4j.core.jackson.ExtendedStackTraceElementMixIn;
import org.elasticsearch.log4j.core.jackson.LevelMixIn;
import org.elasticsearch.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import org.elasticsearch.log4j.core.jackson.LogEventJsonMixIn;
import org.elasticsearch.log4j.core.jackson.LogEventWithContextListMixIn;
import org.elasticsearch.log4j.core.jackson.MarkerMixIn;
import org.elasticsearch.log4j.core.jackson.MutableThreadContextStackDeserializer;
import org.elasticsearch.log4j.core.jackson.StackTraceElementMixIn;
import org.elasticsearch.log4j.core.jackson.ThrowableProxyMixIn;
import org.elasticsearch.log4j.core.jackson.ThrowableProxyWithoutStacktraceMixIn;

class Initializers {
    Initializers() {
    }

    static class SimpleModuleInitializer {
        SimpleModuleInitializer() {
        }

        void initialize(SimpleModule simpleModule) {
            simpleModule.addDeserializer(StackTraceElement.class, (JsonDeserializer)new Log4jStackTraceElementDeserializer());
            simpleModule.addDeserializer(ThreadContext.ContextStack.class, (JsonDeserializer)new MutableThreadContextStackDeserializer());
        }
    }

    static class SetupContextJsonInitializer {
        SetupContextJsonInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventJsonMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? ThrowableProxyMixIn.class : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }

    static class SetupContextInitializer {
        SetupContextInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventWithContextListMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? ThrowableProxyMixIn.class : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }
}

