/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.log4j.core.jackson;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.jackson.core.JsonParser;
import org.elasticsearch.jackson.core.JsonProcessingException;
import org.elasticsearch.jackson.core.JsonToken;
import org.elasticsearch.jackson.databind.DeserializationContext;
import org.elasticsearch.jackson.databind.deser.std.StdDeserializer;
import org.elasticsearch.log4j.core.impl.ContextDataFactory;
import org.elasticsearch.log4j.util.StringMap;

public class ContextDataDeserializer
extends StdDeserializer<StringMap> {
    private static final long serialVersionUID = 1L;

    ContextDataDeserializer() {
        super(Map.class);
    }

    public StringMap deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        StringMap contextData = ContextDataFactory.createContextData();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            contextData.putValue(fieldName, jp.getText());
        }
        return contextData;
    }
}

