/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.log4j.core.config.yaml;

import org.elasticsearch.log4j.core.LoggerContext;
import org.elasticsearch.log4j.core.config.Configuration;
import org.elasticsearch.log4j.core.config.ConfigurationFactory;
import org.elasticsearch.log4j.core.config.ConfigurationSource;
import org.elasticsearch.log4j.core.config.Order;
import org.elasticsearch.log4j.core.config.plugins.Plugin;
import org.elasticsearch.log4j.core.config.yaml.YamlConfiguration;
import org.elasticsearch.log4j.core.util.Loader;

@Plugin(name="YamlConfigurationFactory", category="ConfigurationFactory")
@Order(value=7)
public class YamlConfigurationFactory
extends ConfigurationFactory {
    private static final String[] SUFFIXES = new String[]{".yml", ".yaml"};
    private static final String[] dependencies = new String[]{"org.elasticsearch.jackson.databind.ObjectMapper", "org.elasticsearch.jackson.databind.JsonNode", "org.elasticsearch.jackson.core.JsonParser", "org.elasticsearch.jackson.dataformat.yaml.YAMLFactory"};
    private final boolean isActive;

    public YamlConfigurationFactory() {
        for (String dependency : dependencies) {
            if (Loader.isClassAvailable(dependency)) continue;
            LOGGER.debug("Missing dependencies for Yaml support");
            this.isActive = false;
            return;
        }
        this.isActive = true;
    }

    @Override
    protected boolean isActive() {
        return this.isActive;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        if (!this.isActive) {
            return null;
        }
        return new YamlConfiguration(loggerContext, source);
    }

    @Override
    public String[] getSupportedTypes() {
        return SUFFIXES;
    }
}

