/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.UUID;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.License;

abstract class ExpirationCallback {
    static final String EXPIRATION_JOB_PREFIX = ".license_expiration_job_";
    private final String id;
    private final Orientation orientation;
    private final long min;
    private final long max;
    private final long frequency;

    private ExpirationCallback(Orientation orientation, TimeValue min, TimeValue max, TimeValue frequency) {
        this.orientation = orientation;
        this.min = min == null ? 0L : min.getMillis();
        this.max = max == null ? Long.MAX_VALUE : max.getMillis();
        this.frequency = frequency.getMillis();
        this.id = String.join((CharSequence)"", EXPIRATION_JOB_PREFIX, UUID.randomUUID().toString());
    }

    public final String getId() {
        return this.id;
    }

    public final long getFrequency() {
        return this.frequency;
    }

    final TimeValue delay(long expirationDate, long now) {
        TimeValue delay;
        switch (this.orientation) {
            case PRE: {
                if (expirationDate >= now) {
                    long preExpiryDuration = expirationDate - now;
                    if (preExpiryDuration > this.max) {
                        delay = TimeValue.timeValueMillis(preExpiryDuration - this.max);
                        break;
                    }
                    if (preExpiryDuration <= this.max && preExpiryDuration >= this.min) {
                        delay = TimeValue.timeValueMillis(0L);
                        break;
                    }
                    delay = null;
                    break;
                }
                delay = null;
                break;
            }
            case POST: {
                if (expirationDate >= now) {
                    delay = TimeValue.timeValueMillis(expirationDate - now + this.min);
                    break;
                }
                long expiredDuration = now - expirationDate;
                if (expiredDuration < this.min) {
                    delay = TimeValue.timeValueMillis(this.min - expiredDuration);
                    break;
                }
                if (expiredDuration >= this.min && expiredDuration <= this.max) {
                    delay = TimeValue.timeValueMillis(0L);
                    break;
                }
                delay = null;
                break;
            }
            default: {
                throw new IllegalStateException("orientation [" + (Object)((Object)this.orientation) + "] unknown");
            }
        }
        return delay;
    }

    public final long nextScheduledTimeForExpiry(long expiryDate, long startTime, long time) {
        TimeValue delay = this.delay(expiryDate, time);
        if (delay != null) {
            long delayInMillis = delay.getMillis();
            if (delayInMillis == 0L) {
                if (startTime == time) {
                    return time;
                }
                return time + this.frequency;
            }
            return time + delayInMillis;
        }
        return -1L;
    }

    public abstract void on(License var1);

    public final String toString() {
        return LoggerMessageFormat.format(null, "ExpirationCallback:(orientation [{}],  min [{}], max [{}], freq [{}])", this.orientation.name(), TimeValue.timeValueMillis(this.min), TimeValue.timeValueMillis(this.max), TimeValue.timeValueMillis(this.frequency));
    }

    public static abstract class Post
    extends ExpirationCallback {
        Post(TimeValue min, TimeValue max, TimeValue frequency) {
            super(Orientation.POST, min, max, frequency);
        }
    }

    public static abstract class Pre
    extends ExpirationCallback {
        Pre(TimeValue min, TimeValue max, TimeValue frequency) {
            super(Orientation.PRE, min, max, frequency);
        }
    }

    public static enum Orientation {
        PRE,
        POST;

    }
}

