/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jboss.netty.handler.codec.http.websocketx;

import org.elasticsearch.jboss.netty.buffer.ChannelBuffer;
import org.elasticsearch.jboss.netty.buffer.ChannelBuffers;
import org.elasticsearch.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.elasticsearch.jboss.netty.util.CharsetUtil;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame() {
        this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
    }

    public TextWebSocketFrame(String text) {
        if (text == null || text.length() == 0) {
            this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
        } else {
            this.setBinaryData(ChannelBuffers.copiedBuffer(text, CharsetUtil.UTF_8));
        }
    }

    public TextWebSocketFrame(ChannelBuffer binaryData) {
        this.setBinaryData(binaryData);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, String text) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        if (text == null || text.length() == 0) {
            this.setBinaryData(ChannelBuffers.EMPTY_BUFFER);
        } else {
            this.setBinaryData(ChannelBuffers.copiedBuffer(text, CharsetUtil.UTF_8));
        }
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, ChannelBuffer binaryData) {
        this.setFinalFragment(finalFragment);
        this.setRsv(rsv);
        this.setBinaryData(binaryData);
    }

    public String getText() {
        if (this.getBinaryData() == null) {
            return null;
        }
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.setBinaryData(ChannelBuffers.copiedBuffer(text, CharsetUtil.UTF_8));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(text: " + this.getText() + ')';
    }
}

