/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.log4j.Logger;

public class SharedFSRecoverySourceHandler
extends RecoverySourceHandler {
    private final IndexShard shard;
    private final StartRecoveryRequest request;

    public SharedFSRecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, StartRecoveryRequest request, Supplier<Long> currentClusterStateVersionSupplier, Function<String, Releasable> delayNewRecoveries, Logger logger) {
        super(shard, recoveryTarget, request, currentClusterStateVersionSupplier, delayNewRecoveries, -1, logger);
        this.shard = shard;
        this.request = request;
    }

    @Override
    public RecoveryResponse recoverToTarget() throws IOException {
        boolean engineClosed = false;
        try {
            this.logger.trace("{} recovery [phase1] to {}: skipping phase 1 for shared filesystem", (Object)this.request.shardId(), (Object)this.request.targetNode());
            long maxUnsafeAutoIdTimestamp = this.shard.segmentStats(false).getMaxUnsafeAutoIdTimestamp();
            if (this.request.isPrimaryRelocation()) {
                this.logger.debug("[phase1] closing engine on primary for shared filesystem recovery");
                try {
                    engineClosed = true;
                    this.shard.flushAndCloseEngine();
                }
                catch (IOException e) {
                    this.logger.warn("close engine failed", (Throwable)e);
                    this.shard.failShard("failed to close engine (phase1)", e);
                }
            }
            this.prepareTargetForTranslog(0, maxUnsafeAutoIdTimestamp);
            this.finalizeRecovery();
            return this.response;
        }
        catch (Exception e) {
            if (engineClosed) {
                this.logger.info("recovery failed for primary shadow shard, failing shard");
                this.shard.failShard("primary relocation failed on shared filesystem", e);
            } else {
                this.logger.info("recovery failed on shared filesystem", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    protected int sendSnapshot(Translog.Snapshot snapshot) {
        this.logger.trace("{} skipping recovery of translog snapshot on shared filesystem to: {}", (Object)this.shard.shardId(), (Object)this.request.targetNode());
        return 0;
    }
}

