/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.RateLimitedFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SleepingLockWrapper;
import org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;

public class FsDirectoryService
extends DirectoryService
implements StoreRateLimiting.Listener,
StoreRateLimiting.Provider {
    protected final IndexStore indexStore;
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> {
        switch (s) {
            case "native": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "simple": {
                return SimpleFSLockFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);
    private final CounterMetric rateLimitingTimeInNanos = new CounterMetric();
    private final ShardPath path;

    @Inject
    public FsDirectoryService(IndexSettings indexSettings, IndexStore indexStore, ShardPath path) {
        super(path.getShardId(), indexSettings);
        this.path = path;
        this.indexStore = indexStore;
    }

    @Override
    public long throttleTimeInNanos() {
        return this.rateLimitingTimeInNanos.count();
    }

    @Override
    public StoreRateLimiting rateLimiting() {
        return this.indexStore.rateLimiting();
    }

    @Override
    public Directory newDirectory() throws IOException {
        Path location = this.path.resolveIndex();
        LockFactory lockFactory = this.indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        Directory wrapped = this.newFSDirectory(location, lockFactory);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)this.indexSettings.getValue(IndexModule.INDEX_STORE_PRE_LOAD_SETTING));
        wrapped = FsDirectoryService.setPreload(wrapped, location, lockFactory, preLoadExtensions);
        if (this.indexSettings.isOnSharedFilesystem()) {
            wrapped = new SleepingLockWrapper(wrapped, 5000L);
        }
        return new RateLimitedFSDirectory(wrapped, this, this);
    }

    @Override
    public void onPause(long nanos) {
        this.rateLimitingTimeInNanos.inc(nanos);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory) throws IOException {
        String storeType = this.indexSettings.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.FS.getSettingsKey());
        if (IndexModule.Type.FS.match(storeType)) {
            return FSDirectory.open(location, lockFactory);
        }
        if (IndexModule.Type.DEFAULT.match(storeType)) {
            this.deprecationLogger.deprecated("[default] store type is deprecated, use [fs] instead", new Object[0]);
            return FSDirectory.open(location, lockFactory);
        }
        if (IndexModule.Type.SIMPLEFS.match(storeType)) {
            return new SimpleFSDirectory(location, lockFactory);
        }
        if (IndexModule.Type.NIOFS.match(storeType)) {
            return new NIOFSDirectory(location, lockFactory);
        }
        if (IndexModule.Type.MMAPFS.match(storeType)) {
            return new MMapDirectory(location, lockFactory);
        }
        throw new IllegalArgumentException("No directory found for type [" + storeType + "]");
    }

    private static Directory setPreload(Directory directory, Path location, LockFactory lockFactory, Set<String> preLoadExtensions) throws IOException {
        if (!preLoadExtensions.isEmpty() && directory instanceof MMapDirectory && !((MMapDirectory)directory).getPreload()) {
            if (preLoadExtensions.contains("*")) {
                ((MMapDirectory)directory).setPreload(true);
                return directory;
            }
            final MMapDirectory primary = new MMapDirectory(location, lockFactory);
            primary.setPreload(true);
            return new FileSwitchDirectory(preLoadExtensions, primary, directory, true){

                @Override
                public String[] listAll() throws IOException {
                    return primary.listAll();
                }
            };
        }
        return directory;
    }
}

