/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesTermsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public final class ParentIdQueryBuilder
extends AbstractQueryBuilder<ParentIdQueryBuilder> {
    public static final String NAME = "parent_id";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", "child_type");
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String type;
    private final String id;
    private boolean ignoreUnmapped = false;

    public ParentIdQueryBuilder(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public ParentIdQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public ParentIdQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<ParentIdQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String type = null;
        String id = null;
        String queryName = null;
        String currentFieldName = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TYPE_FIELD.match(currentFieldName)) {
                    type = parser.text();
                    continue;
                }
                if (ID_FIELD.match(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                    ignoreUnmapped = parser.booleanValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[parent_id] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[parent_id] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        ParentIdQueryBuilder queryBuilder = new ParentIdQueryBuilder(type, id);
        queryBuilder.queryName(queryName);
        queryBuilder.boost(boost);
        queryBuilder.ignoreUnmapped(ignoreUnmapped);
        return Optional.of(queryBuilder);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        DocumentMapper childDocMapper = context.getMapperService().documentMapper(this.type);
        if (childDocMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[parent_id] no mapping found for type [" + this.type + "]", new Object[0]);
        }
        ParentFieldMapper parentFieldMapper = childDocMapper.parentFieldMapper();
        if (!parentFieldMapper.active()) {
            throw new QueryShardException(context, "[parent_id] _parent field has no parent type configured", new Object[0]);
        }
        String fieldName = ParentFieldMapper.joinField(parentFieldMapper.type());
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add(new DocValuesTermsQuery(fieldName, this.id), BooleanClause.Occur.MUST);
        query.add(new TermQuery(new Term("_type", this.type)), BooleanClause.Occur.FILTER);
        return query.build();
    }

    @Override
    protected boolean doEquals(ParentIdQueryBuilder that) {
        return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.type, this.id, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

