/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.all.AllEntries;
import org.elasticsearch.common.lucene.all.AllField;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.EnabledAttributeMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;

public class AllFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    private EnabledAttributeMapper enabledState;

    private AllFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing.clone(), Defaults.ENABLED, indexSettings);
    }

    private AllFieldMapper(MappedFieldType fieldType, EnabledAttributeMapper enabled, Settings indexSettings) {
        super("_all", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.enabledState = enabled;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (!this.enabledState.enabled) {
            return;
        }
        for (AllEntries.Entry entry : context.allEntries().entries()) {
            fields.add(new AllField(this.fieldType().name(), entry.value(), entry.boost(), this.fieldType()));
        }
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults) {
            BytesStreamOutput bytesStreamOutput = new BytesStreamOutput(0);
            XContentBuilder b = new XContentBuilder(builder.contentType().xContent(), bytesStreamOutput);
            b.startObject().flush();
            long pos = bytesStreamOutput.position();
            this.innerToXContent(b, false);
            b.flush();
            if (pos == bytesStreamOutput.position()) {
                return builder;
            }
        }
        builder.startObject("_all");
        this.innerToXContent(builder, includeDefaults);
        builder.endObject();
        return builder;
    }

    private void innerToXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (includeDefaults || this.enabledState != Defaults.ENABLED) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || this.fieldType().storeTermVectors() != Defaults.FIELD_TYPE.storeTermVectors()) {
            builder.field("store_term_vectors", this.fieldType().storeTermVectors());
        }
        if (includeDefaults || this.fieldType().storeTermVectorOffsets() != Defaults.FIELD_TYPE.storeTermVectorOffsets()) {
            builder.field("store_term_vector_offsets", this.fieldType().storeTermVectorOffsets());
        }
        if (includeDefaults || this.fieldType().storeTermVectorPositions() != Defaults.FIELD_TYPE.storeTermVectorPositions()) {
            builder.field("store_term_vector_positions", this.fieldType().storeTermVectorPositions());
        }
        if (includeDefaults || this.fieldType().storeTermVectorPayloads() != Defaults.FIELD_TYPE.storeTermVectorPayloads()) {
            builder.field("store_term_vector_payloads", this.fieldType().storeTermVectorPayloads());
        }
        if (includeDefaults || this.fieldType().omitNorms() != Defaults.FIELD_TYPE.omitNorms()) {
            builder.field("norms", !this.fieldType().omitNorms());
        }
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.fieldType().similarity() != null) {
            builder.field("similarity", this.fieldType().similarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "BM25");
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        if (((AllFieldMapper)mergeWith).enabled() != this.enabled() && ((AllFieldMapper)mergeWith).enabledState != Defaults.ENABLED) {
            throw new IllegalArgumentException("mapper [" + this.fieldType().name() + "] enabled is " + this.enabled() + " now encountering " + ((AllFieldMapper)mergeWith).enabled());
        }
        super.doMerge(mergeWith, updateAllTypes);
    }

    static final class AllFieldType
    extends StringFieldType {
        AllFieldType() {
        }

        protected AllFieldType(AllFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new AllFieldType(this);
        }

        @Override
        public String typeName() {
            return "_all";
        }

        @Override
        public Query queryStringTermQuery(Term term) {
            return new AllTermQuery(term);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.queryStringTermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Map<String, Object> fielddataMap;
            Object format;
            Builder builder = new Builder(parserContext.mapperService().fullName("_all"));
            builder.fieldType().setIndexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.fieldType().setSearchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.fieldType().setSearchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            Object docValues = node.get("doc_values");
            if (docValues != null && TypeParsers.nodeBooleanValue(name, "doc_values", docValues)) {
                throw new MapperParsingException("Field [" + name + "] is always tokenized and cannot have doc values");
            }
            Object fielddata = node.get("fielddata");
            if (fielddata != null && "doc_values".equals(format = (fielddataMap = XContentMapValues.nodeMapValue(fielddata, "fielddata")).get("format"))) {
                throw new MapperParsingException("Field [" + name + "] is always tokenized and cannot have doc values");
            }
            TypeParsers.parseTextField(builder, builder.name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                boolean enabled = TypeParsers.nodeBooleanValue(name, "enabled", fieldNode);
                builder.enabled(enabled ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED);
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new AllFieldMapper(indexSettings, fieldType);
            }
            return (MetadataFieldMapper)this.parse("_all", Collections.emptyMap(), context).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, AllFieldMapper> {
        private EnabledAttributeMapper enabled = Defaults.ENABLED;

        public Builder(MappedFieldType existing) {
            super("_all", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public AllFieldMapper build(Mapper.BuilderContext context) {
            if (this.fieldType.indexOptions() == IndexOptions.NONE) {
                this.fieldType.setIndexOptions(Defaults.FIELD_TYPE.indexOptions());
            } else {
                this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), 100));
                this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), 100));
                this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), 100));
            }
            this.fieldType.setTokenized(true);
            return new AllFieldMapper(this.fieldType, this.enabled, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_all";
        public static final String INDEX_NAME = "_all";
        public static final EnabledAttributeMapper ENABLED = EnabledAttributeMapper.UNSET_ENABLED;
        public static final int POSITION_INCREMENT_GAP = 100;
        public static final MappedFieldType FIELD_TYPE = new AllFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setName("_all");
            FIELD_TYPE.freeze();
        }
    }
}

