/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.elasticsearch.common.geo.builders.EnvelopeBuilder;
import org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiPointBuilder;
import org.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilders;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.log4j.Logger;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public abstract class ShapeBuilder
extends ToXContentToBytes
implements NamedWriteable {
    protected static final Logger LOGGER = ESLoggerFactory.getLogger(ShapeBuilder.class.getName());
    private static final boolean DEBUG;
    public static final double DATELINE = 180.0;
    public static final Coordinate ZERO_ZERO;
    public static final JtsSpatialContext SPATIAL_CONTEXT;
    public static final GeometryFactory FACTORY;
    protected final boolean wrapdateline = SPATIAL_CONTEXT.isGeo();
    protected final boolean multiPolygonMayOverlap = false;
    protected final boolean autoValidateJtsGeometry = true;
    protected final boolean autoIndexJtsGeometry = true;
    protected static final IntersectionOrder INTERSECTION_ORDER;
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_COORDINATES = "coordinates";
    public static final String FIELD_GEOMETRIES = "geometries";
    public static final String FIELD_ORIENTATION = "orientation";

    protected ShapeBuilder() {
    }

    protected JtsGeometry jtsGeometry(Geometry geom) {
        JtsGeometry jtsGeometry = new JtsGeometry(geom, SPATIAL_CONTEXT, false, false);
        jtsGeometry.validate();
        jtsGeometry.index();
        return jtsGeometry;
    }

    public abstract Shape build();

    private static CoordinateNode parseCoordinates(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.END_ARRAY && token != XContentParser.Token.VALUE_NULL) {
            double lon = parser.doubleValue();
            token = parser.nextToken();
            double lat = parser.doubleValue();
            token = parser.nextToken();
            while (token == XContentParser.Token.VALUE_NUMBER) {
                token = parser.nextToken();
            }
            return new CoordinateNode(new Coordinate(lon, lat));
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("coordinates cannot contain NULL values)");
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            nodes.add(ShapeBuilder.parseCoordinates(parser));
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    public static ShapeBuilder parse(XContentParser parser) throws IOException {
        return GeoShapeType.parse(parser, null);
    }

    public static ShapeBuilder parse(XContentParser parser, GeoShapeFieldMapper geoDocMapper) throws IOException {
        return GeoShapeType.parse(parser, geoDocMapper);
    }

    protected static XContentBuilder toXContent(XContentBuilder builder, Coordinate coordinate) throws IOException {
        return builder.startArray().value(coordinate.x).value(coordinate.y).endArray();
    }

    protected static void writeCoordinateTo(Coordinate coordinate, StreamOutput out) throws IOException {
        out.writeDouble(coordinate.x);
        out.writeDouble(coordinate.y);
    }

    protected static Coordinate readFromStream(StreamInput in) throws IOException {
        return new Coordinate(in.readDouble(), in.readDouble());
    }

    protected static Coordinate shift(Coordinate coordinate, double dateline) {
        if (dateline == 0.0) {
            return coordinate;
        }
        return new Coordinate(-2.0 * dateline + coordinate.x, coordinate.y);
    }

    public abstract GeoShapeType type();

    protected static final double intersection(Coordinate p1, Coordinate p2, double dateline) {
        if (p1.x == p2.x && p1.x != dateline) {
            return Double.NaN;
        }
        if (p1.x == p2.x && p1.x == dateline) {
            return 1.0;
        }
        double t = (dateline - p1.x) / (p2.x - p1.x);
        if (t > 1.0 || t <= 0.0) {
            return Double.NaN;
        }
        return t;
    }

    protected static int intersections(double dateline, Edge[] edges) {
        int numIntersections = 0;
        assert (!Double.isNaN(dateline));
        for (int i = 0; i < edges.length; ++i) {
            Coordinate p1 = edges[i].coordinate;
            Coordinate p2 = edges[i].next.coordinate;
            assert (!Double.isNaN(p2.x) && !Double.isNaN(p1.x));
            edges[i].intersect = Edge.MAX_COORDINATE;
            double position = ShapeBuilder.intersection(p1, p2, dateline);
            if (Double.isNaN(position)) continue;
            edges[i].intersection(position);
            ++numIntersections;
        }
        Arrays.sort(edges, INTERSECTION_ORDER);
        return numIntersections;
    }

    protected static final boolean debugEnabled() {
        return LOGGER.isDebugEnabled() || DEBUG;
    }

    @Override
    public String getWriteableName() {
        return this.type().shapeName();
    }

    static {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        DEBUG = debug;
        ZERO_ZERO = new Coordinate(0.0, 0.0);
        SPATIAL_CONTEXT = JtsSpatialContext.GEO;
        FACTORY = SPATIAL_CONTEXT.getGeometryFactory();
        INTERSECTION_ORDER = new IntersectionOrder();
    }

    public static enum GeoShapeType {
        POINT("point"),
        MULTIPOINT("multipoint"),
        LINESTRING("linestring"),
        MULTILINESTRING("multilinestring"),
        POLYGON("polygon"),
        MULTIPOLYGON("multipolygon"),
        GEOMETRYCOLLECTION("geometrycollection"),
        ENVELOPE("envelope"),
        CIRCLE("circle");

        private final String shapename;

        private GeoShapeType(String shapename) {
            this.shapename = shapename;
        }

        protected String shapeName() {
            return this.shapename;
        }

        public static GeoShapeType forName(String geoshapename) {
            String typename = geoshapename.toLowerCase(Locale.ROOT);
            for (GeoShapeType type : GeoShapeType.values()) {
                if (!type.shapename.equals(typename)) continue;
                return type;
            }
            throw new IllegalArgumentException("unknown geo_shape [" + geoshapename + "]");
        }

        public static ShapeBuilder parse(XContentParser parser) throws IOException {
            return GeoShapeType.parse(parser, null);
        }

        public static ShapeBuilder parse(XContentParser parser, GeoShapeFieldMapper shapeMapper) throws IOException {
            XContentParser.Token token;
            boolean coerce;
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
            }
            Enum shapeType = null;
            DistanceUnit.Distance radius = null;
            CoordinateNode node = null;
            GeometryCollectionBuilder geometryCollections = null;
            Orientation requestedOrientation = shapeMapper == null ? Orientation.RIGHT : shapeMapper.fieldType().orientation();
            boolean bl = coerce = shapeMapper == null ? GeoShapeFieldMapper.Defaults.COERCE.value().booleanValue() : shapeMapper.coerce().value().booleanValue();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String fieldName = parser.currentName();
                if (ShapeBuilder.FIELD_TYPE.equals(fieldName)) {
                    parser.nextToken();
                    shapeType = GeoShapeType.forName(parser.text());
                    continue;
                }
                if (ShapeBuilder.FIELD_COORDINATES.equals(fieldName)) {
                    parser.nextToken();
                    node = ShapeBuilder.parseCoordinates(parser);
                    continue;
                }
                if (ShapeBuilder.FIELD_GEOMETRIES.equals(fieldName)) {
                    parser.nextToken();
                    geometryCollections = GeoShapeType.parseGeometries(parser, shapeMapper);
                    continue;
                }
                if ("radius".equals(fieldName)) {
                    parser.nextToken();
                    radius = DistanceUnit.Distance.parseDistance(parser.text());
                    continue;
                }
                if (ShapeBuilder.FIELD_ORIENTATION.equals(fieldName)) {
                    parser.nextToken();
                    requestedOrientation = Orientation.fromString(parser.text());
                    continue;
                }
                parser.nextToken();
                parser.skipChildren();
            }
            if (shapeType == null) {
                throw new ElasticsearchParseException("shape type not included", new Object[0]);
            }
            if (node == null && GEOMETRYCOLLECTION != shapeType) {
                throw new ElasticsearchParseException("coordinates not included", new Object[0]);
            }
            if (geometryCollections == null && GEOMETRYCOLLECTION == shapeType) {
                throw new ElasticsearchParseException("geometries not included", new Object[0]);
            }
            if (radius != null && CIRCLE != shapeType) {
                throw new ElasticsearchParseException("field [{}] is supported for [{}] only", new Object[]{"radius", CircleBuilder.TYPE});
            }
            switch (1.$SwitchMap$org$elasticsearch$common$geo$builders$ShapeBuilder$GeoShapeType[shapeType.ordinal()]) {
                case 1: {
                    return GeoShapeType.parsePoint(node);
                }
                case 2: {
                    return GeoShapeType.parseMultiPoint(node);
                }
                case 3: {
                    return GeoShapeType.parseLineString(node);
                }
                case 4: {
                    return GeoShapeType.parseMultiLine(node);
                }
                case 5: {
                    return GeoShapeType.parsePolygon(node, requestedOrientation, coerce);
                }
                case 6: {
                    return GeoShapeType.parseMultiPolygon(node, requestedOrientation, coerce);
                }
                case 7: {
                    return GeoShapeType.parseCircle(node, radius);
                }
                case 8: {
                    return GeoShapeType.parseEnvelope(node);
                }
                case 9: {
                    return geometryCollections;
                }
            }
            throw new ElasticsearchParseException("shape type [{}] not included", shapeType);
        }

        protected static void validatePointNode(CoordinateNode node) {
            if (node.isEmpty()) {
                throw new ElasticsearchParseException("invalid number of points (0) provided when expecting a single coordinate ([lat, lng])", new Object[0]);
            }
            if (node.coordinate == null && !node.children.isEmpty()) {
                throw new ElasticsearchParseException("multipoint data provided when single point data expected.", new Object[0]);
            }
        }

        protected static PointBuilder parsePoint(CoordinateNode node) {
            GeoShapeType.validatePointNode(node);
            return ShapeBuilders.newPoint(node.coordinate);
        }

        protected static CircleBuilder parseCircle(CoordinateNode coordinates, DistanceUnit.Distance radius) {
            return ShapeBuilders.newCircleBuilder().center(coordinates.coordinate).radius(radius);
        }

        protected static EnvelopeBuilder parseEnvelope(CoordinateNode coordinates) {
            if (coordinates.children.size() != 2) {
                throw new ElasticsearchParseException("invalid number of points [{}] provided for geo_shape [{}] when expecting an array of 2 coordinates", coordinates.children.size(), GeoShapeType.ENVELOPE.shapename);
            }
            Coordinate uL = coordinates.children.get((int)0).coordinate;
            Coordinate lR = coordinates.children.get((int)1).coordinate;
            if (lR.x < uL.x || uL.y < lR.y) {
                Coordinate uLtmp = uL;
                uL = new Coordinate(Math.min(uL.x, lR.x), Math.max(uL.y, lR.y));
                lR = new Coordinate(Math.max(uLtmp.x, lR.x), Math.min(uLtmp.y, lR.y));
            }
            return ShapeBuilders.newEnvelope(uL, lR);
        }

        protected static void validateMultiPointNode(CoordinateNode coordinates) {
            if (coordinates.children == null || coordinates.children.isEmpty()) {
                if (coordinates.coordinate != null) {
                    throw new ElasticsearchParseException("single coordinate found when expecting an array of coordinates. change type to point or change data to an array of >0 coordinates", new Object[0]);
                }
                throw new ElasticsearchParseException("no data provided for multipoint object when expecting >0 points (e.g., [[lat, lng]] or [[lat, lng], ...])", new Object[0]);
            }
            for (CoordinateNode point : coordinates.children) {
                GeoShapeType.validatePointNode(point);
            }
        }

        protected static MultiPointBuilder parseMultiPoint(CoordinateNode coordinates) {
            GeoShapeType.validateMultiPointNode(coordinates);
            CoordinatesBuilder points = new CoordinatesBuilder();
            for (CoordinateNode node : coordinates.children) {
                points.coordinate(node.coordinate);
            }
            return new MultiPointBuilder(points.build());
        }

        protected static LineStringBuilder parseLineString(CoordinateNode coordinates) {
            if (coordinates.children.size() < 2) {
                throw new ElasticsearchParseException("invalid number of points in LineString (found [{}] - must be >= 2)", coordinates.children.size());
            }
            CoordinatesBuilder line = new CoordinatesBuilder();
            for (CoordinateNode node : coordinates.children) {
                line.coordinate(node.coordinate);
            }
            return ShapeBuilders.newLineString(line);
        }

        protected static MultiLineStringBuilder parseMultiLine(CoordinateNode coordinates) {
            MultiLineStringBuilder multiline = ShapeBuilders.newMultiLinestring();
            for (CoordinateNode node : coordinates.children) {
                multiline.linestring(GeoShapeType.parseLineString(node));
            }
            return multiline;
        }

        protected static LineStringBuilder parseLinearRing(CoordinateNode coordinates, boolean coerce) {
            int numValidPts;
            if (coordinates.children == null) {
                String error = "Invalid LinearRing found.";
                error = error + (coordinates.coordinate == null ? " No coordinate array provided" : " Found a single coordinate when expecting a coordinate array");
                throw new ElasticsearchParseException(error, new Object[0]);
            }
            int n = numValidPts = coerce ? 3 : 4;
            if (coordinates.children.size() < numValidPts) {
                throw new ElasticsearchParseException("invalid number of points in LinearRing (found [{}] - must be >= [{}])", coordinates.children.size(), numValidPts);
            }
            if (!coordinates.children.get((int)0).coordinate.equals((Object)coordinates.children.get((int)(coordinates.children.size() - 1)).coordinate)) {
                if (coerce) {
                    coordinates.children.add(coordinates.children.get(0));
                } else {
                    throw new ElasticsearchParseException("invalid LinearRing found (coordinates are not closed)", new Object[0]);
                }
            }
            return GeoShapeType.parseLineString(coordinates);
        }

        protected static PolygonBuilder parsePolygon(CoordinateNode coordinates, Orientation orientation, boolean coerce) {
            if (coordinates.children == null || coordinates.children.isEmpty()) {
                throw new ElasticsearchParseException("invalid LinearRing provided for type polygon. Linear ring must be an array of coordinates", new Object[0]);
            }
            LineStringBuilder shell = GeoShapeType.parseLinearRing(coordinates.children.get(0), coerce);
            PolygonBuilder polygon = new PolygonBuilder(shell, orientation);
            for (int i = 1; i < coordinates.children.size(); ++i) {
                polygon.hole(GeoShapeType.parseLinearRing(coordinates.children.get(i), coerce));
            }
            return polygon;
        }

        protected static MultiPolygonBuilder parseMultiPolygon(CoordinateNode coordinates, Orientation orientation, boolean coerce) {
            MultiPolygonBuilder polygons = ShapeBuilders.newMultiPolygon(orientation);
            for (CoordinateNode node : coordinates.children) {
                polygons.polygon(GeoShapeType.parsePolygon(node, orientation, coerce));
            }
            return polygons;
        }

        protected static GeometryCollectionBuilder parseGeometries(XContentParser parser, GeoShapeFieldMapper mapper) throws IOException {
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("geometries must be an array of geojson objects", new Object[0]);
            }
            XContentParser.Token token = parser.nextToken();
            GeometryCollectionBuilder geometryCollection = ShapeBuilders.newGeometryCollection();
            while (token != XContentParser.Token.END_ARRAY) {
                ShapeBuilder shapeBuilder = GeoShapeType.parse(parser);
                geometryCollection.shape(shapeBuilder);
                token = parser.nextToken();
            }
            return geometryCollection;
        }
    }

    public static enum Orientation {
        LEFT,
        RIGHT;

        public static final Orientation CLOCKWISE;
        public static final Orientation COUNTER_CLOCKWISE;
        public static final Orientation CW;
        public static final Orientation CCW;

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this == RIGHT);
        }

        public static Orientation readFrom(StreamInput in) throws IOException {
            return in.readBoolean() ? RIGHT : LEFT;
        }

        public static Orientation fromString(String orientation) {
            switch (orientation = orientation.toLowerCase(Locale.ROOT)) {
                case "right": 
                case "counterclockwise": 
                case "ccw": {
                    return RIGHT;
                }
                case "left": 
                case "clockwise": 
                case "cw": {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unknown orientation [" + orientation + "]");
        }

        static {
            CLOCKWISE = LEFT;
            COUNTER_CLOCKWISE = RIGHT;
            CW = LEFT;
            CCW = RIGHT;
        }
    }

    private static final class IntersectionOrder
    implements Comparator<Edge> {
        private IntersectionOrder() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            return Double.compare(o1.intersect.y, o2.intersect.y);
        }
    }

    protected static final class Edge {
        Coordinate coordinate;
        Edge next;
        Coordinate intersect;
        int component = -1;
        public static final Coordinate MAX_COORDINATE = new Coordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

        protected Edge(Coordinate coordinate, Edge next, Coordinate intersection) {
            this.coordinate = coordinate;
            this.setNext(next);
            this.intersect = intersection;
            if (next != null) {
                this.component = next.component;
            }
        }

        protected Edge(Coordinate coordinate, Edge next) {
            this(coordinate, next, MAX_COORDINATE);
        }

        protected void setNext(Edge next) {
            if (next != null) {
                if (this.coordinate.equals((Object)next.coordinate)) {
                    throw new InvalidShapeException("Provided shape has duplicate consecutive coordinates at: " + this.coordinate);
                }
                this.next = next;
            }
        }

        protected Coordinate intersection(double position) {
            this.intersect = Edge.position(this.coordinate, this.next.coordinate, position);
            return this.intersect;
        }

        protected static Coordinate position(Coordinate p1, Coordinate p2, double position) {
            if (position == 0.0) {
                return p1;
            }
            if (position == 1.0) {
                return p2;
            }
            double x = p1.x + position * (p2.x - p1.x);
            double y = p1.y + position * (p2.y - p1.y);
            return new Coordinate(x, y);
        }

        public String toString() {
            return "Edge[Component=" + this.component + "; start=" + this.coordinate + " ; intersection=" + this.intersect + "]";
        }
    }

    protected static class CoordinateNode
    implements ToXContent {
        protected final Coordinate coordinate;
        protected final List<CoordinateNode> children;

        protected CoordinateNode(Coordinate coordinate) {
            this.coordinate = coordinate;
            this.children = null;
        }

        protected CoordinateNode(List<CoordinateNode> children) {
            this.children = children;
            this.coordinate = null;
        }

        protected boolean isEmpty() {
            return this.coordinate == null && (this.children == null || this.children.isEmpty());
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.children == null) {
                builder.startArray().value(this.coordinate.x).value(this.coordinate.y).endArray();
            } else {
                builder.startArray();
                for (CoordinateNode child : this.children) {
                    child.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }
    }
}

