/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.sniff;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.ElasticsearchHostsSniffer;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.Sniffer;

public final class SnifferBuilder {
    public static final long DEFAULT_SNIFF_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    public static final long DEFAULT_SNIFF_AFTER_FAILURE_DELAY = TimeUnit.MINUTES.toMillis(1L);
    private final RestClient restClient;
    private long sniffIntervalMillis = DEFAULT_SNIFF_INTERVAL;
    private long sniffAfterFailureDelayMillis = DEFAULT_SNIFF_AFTER_FAILURE_DELAY;
    private HostsSniffer hostsSniffer;

    SnifferBuilder(RestClient restClient) {
        Objects.requireNonNull(restClient, "restClient cannot be null");
        this.restClient = restClient;
    }

    public SnifferBuilder setSniffIntervalMillis(int sniffIntervalMillis) {
        if (sniffIntervalMillis <= 0) {
            throw new IllegalArgumentException("sniffIntervalMillis must be greater than 0");
        }
        this.sniffIntervalMillis = sniffIntervalMillis;
        return this;
    }

    public SnifferBuilder setSniffAfterFailureDelayMillis(int sniffAfterFailureDelayMillis) {
        if (sniffAfterFailureDelayMillis <= 0) {
            throw new IllegalArgumentException("sniffAfterFailureDelayMillis must be greater than 0");
        }
        this.sniffAfterFailureDelayMillis = sniffAfterFailureDelayMillis;
        return this;
    }

    public SnifferBuilder setHostsSniffer(HostsSniffer hostsSniffer) {
        Objects.requireNonNull(hostsSniffer, "hostsSniffer cannot be null");
        this.hostsSniffer = hostsSniffer;
        return this;
    }

    public Sniffer build() {
        if (this.hostsSniffer == null) {
            this.hostsSniffer = new ElasticsearchHostsSniffer(this.restClient);
        }
        return new Sniffer(this.restClient, this.hostsSniffer, this.sniffIntervalMillis, this.sniffAfterFailureDelayMillis);
    }
}

