/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.sniff;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;

public class Sniffer
implements Closeable {
    private static final Log logger = LogFactory.getLog(Sniffer.class);
    private final Task task;

    Sniffer(RestClient restClient, HostsSniffer hostsSniffer, long sniffInterval, long sniffAfterFailureDelay) {
        this.task = new Task(hostsSniffer, restClient, sniffInterval, sniffAfterFailureDelay);
    }

    public void sniffOnFailure(HttpHost failedHost) {
        this.task.sniffOnFailure(failedHost);
    }

    @Override
    public void close() throws IOException {
        this.task.shutdown();
    }

    public static SnifferBuilder builder(RestClient restClient) {
        return new SnifferBuilder(restClient);
    }

    private static class Task
    implements Runnable {
        private final HostsSniffer hostsSniffer;
        private final RestClient restClient;
        private final long sniffIntervalMillis;
        private final long sniffAfterFailureDelayMillis;
        private final ScheduledExecutorService scheduledExecutorService;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private ScheduledFuture<?> scheduledFuture;

        private Task(HostsSniffer hostsSniffer, RestClient restClient, long sniffIntervalMillis, long sniffAfterFailureDelayMillis) {
            this.hostsSniffer = hostsSniffer;
            this.restClient = restClient;
            this.sniffIntervalMillis = sniffIntervalMillis;
            this.sniffAfterFailureDelayMillis = sniffAfterFailureDelayMillis;
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
            this.scheduleNextRun(0L);
        }

        synchronized void scheduleNextRun(long delayMillis) {
            if (!this.scheduledExecutorService.isShutdown()) {
                try {
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(false);
                    }
                    logger.debug("scheduling next sniff in " + delayMillis + " ms");
                    this.scheduledFuture = this.scheduledExecutorService.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    logger.error("error while scheduling next sniffer task", e);
                }
            }
        }

        @Override
        public void run() {
            this.sniff(null, this.sniffIntervalMillis);
        }

        void sniffOnFailure(HttpHost failedHost) {
            this.sniff(failedHost, this.sniffAfterFailureDelayMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sniff(HttpHost excludeHost, long nextSniffDelayMillis) {
            if (this.running.compareAndSet(false, true)) {
                try {
                    List<HttpHost> sniffedHosts = this.hostsSniffer.sniffHosts();
                    logger.debug("sniffed hosts: " + sniffedHosts);
                    if (excludeHost != null) {
                        sniffedHosts.remove(excludeHost);
                    }
                    if (sniffedHosts.isEmpty()) {
                        logger.warn("no hosts to set, hosts will be updated at the next sniffing round");
                    } else {
                        this.restClient.setHosts(sniffedHosts.toArray(new HttpHost[sniffedHosts.size()]));
                    }
                }
                catch (Exception e) {
                    logger.error("error while sniffing nodes", e);
                }
                finally {
                    this.scheduleNextRun(nextSniffDelayMillis);
                    this.running.set(false);
                }
            }
        }

        synchronized void shutdown() {
            this.scheduledExecutorService.shutdown();
            try {
                if (this.scheduledExecutorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                this.scheduledExecutorService.shutdownNow();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

