/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.sniff;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;

public class SniffOnFailureListener
extends RestClient.FailureListener {
    private volatile Sniffer sniffer;
    private final AtomicBoolean set = new AtomicBoolean(false);

    public void setSniffer(Sniffer sniffer) {
        Objects.requireNonNull(sniffer, "sniffer must not be null");
        if (!this.set.compareAndSet(false, true)) {
            throw new IllegalStateException("sniffer can only be set once");
        }
        this.sniffer = sniffer;
    }

    @Override
    public void onFailure(HttpHost host) {
        if (this.sniffer == null) {
            throw new IllegalStateException("sniffer was not set, unable to sniff on failure");
        }
        this.sniffer.sniffOnFailure(host);
    }
}

