/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntConsumer;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.search.AbstractAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.Transport;

abstract class AbstractSearchAsyncAction<FirstResult extends SearchPhaseResult>
extends AbstractAsyncAction {
    private static final float DEFAULT_INDEX_BOOST = 1.0f;
    protected final Logger logger;
    protected final SearchTransportService searchTransportService;
    private final Executor executor;
    protected final ActionListener<SearchResponse> listener;
    private final GroupShardsIterator shardsIts;
    protected final SearchRequest request;
    protected final Function<String, Transport.Connection> nodeIdToConnection;
    protected final SearchPhaseController searchPhaseController;
    protected final SearchTask task;
    private final int expectedSuccessfulOps;
    private final int expectedTotalOps;
    private final AtomicInteger successfulOps = new AtomicInteger();
    private final AtomicInteger totalOps = new AtomicInteger();
    private final AtomicArray<FirstResult> initialResults;
    private final Map<String, AliasFilter> aliasFilter;
    private final Map<String, Float> concreteIndexBoosts;
    private final long clusterStateVersion;
    private volatile AtomicArray<ShardSearchFailure> shardFailures;
    private final Object shardFailuresMutex = new Object();

    protected AbstractSearchAsyncAction(Logger logger, SearchTransportService searchTransportService, Function<String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator shardsIts, long startTime, long clusterStateVersion, SearchTask task) {
        super(startTime);
        this.logger = logger;
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        this.executor = executor;
        this.request = request;
        this.task = task;
        this.listener = listener;
        this.nodeIdToConnection = nodeIdToConnection;
        this.clusterStateVersion = clusterStateVersion;
        this.shardsIts = shardsIts;
        this.expectedSuccessfulOps = shardsIts.size();
        this.expectedTotalOps = shardsIts.totalSizeWith1ForEmpty();
        this.initialResults = new AtomicArray(shardsIts.size());
        this.aliasFilter = aliasFilter;
        this.concreteIndexBoosts = concreteIndexBoosts;
    }

    @Override
    public void start() {
        if (this.expectedSuccessfulOps == 0) {
            this.listener.onResponse(new SearchResponse(InternalSearchResponse.empty(), null, 0, 0, this.buildTookInMillis(), ShardSearchFailure.EMPTY_ARRAY));
            return;
        }
        int shardIndex = -1;
        for (ShardIterator shardIt : this.shardsIts) {
            ++shardIndex;
            ShardRouting shard = shardIt.nextOrNull();
            if (shard != null) {
                this.performInitialPhase(shardIndex, shardIt, shard);
                continue;
            }
            this.onInitialPhaseResult(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
        }
    }

    void performInitialPhase(final int shardIndex, final ShardIterator shardIt, final ShardRouting shard) {
        if (shard == null) {
            this.onInitialPhaseResult(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
        } else {
            try {
                final Transport.Connection connection = this.nodeIdToConnection.apply(shard.currentNodeId());
                AliasFilter filter = this.aliasFilter.get(shard.index().getUUID());
                assert (filter != null);
                float indexBoost = this.concreteIndexBoosts.getOrDefault(shard.index().getUUID(), Float.valueOf(1.0f)).floatValue();
                ShardSearchTransportRequest transportRequest = new ShardSearchTransportRequest(this.request, shardIt.shardId(), this.shardsIts.size(), filter, indexBoost, this.startTime());
                this.sendExecuteFirstPhase(connection, transportRequest, new ActionListener<FirstResult>(){

                    @Override
                    public void onResponse(FirstResult result) {
                        AbstractSearchAsyncAction.this.onInitialPhaseResult(shardIndex, shard.currentNodeId(), result, shardIt);
                    }

                    @Override
                    public void onFailure(Exception t) {
                        AbstractSearchAsyncAction.this.onInitialPhaseResult(shardIndex, shard, connection.getNode().getId(), shardIt, t);
                    }
                });
            }
            catch (IllegalArgumentException | ConnectTransportException ex) {
                this.onInitialPhaseResult(shardIndex, shard, shard.currentNodeId(), shardIt, ex);
            }
        }
    }

    private void onInitialPhaseResult(int shardIndex, String nodeId, FirstResult result, ShardIterator shardIt) {
        result.shardTarget(new SearchShardTarget(nodeId, shardIt.shardId()));
        this.processFirstPhaseResult(shardIndex, result);
        this.successfulOps.incrementAndGet();
        int xTotalOps = this.totalOps.addAndGet(shardIt.remaining() + 1);
        if (xTotalOps == this.expectedTotalOps) {
            this.executePhase(this.initialPhaseName(), this.innerGetNextPhase(), null);
        } else if (xTotalOps > this.expectedTotalOps) {
            this.raiseEarlyFailure(new IllegalStateException("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]"));
        }
    }

    protected void executePhase(String phaseName, CheckedRunnable<Exception> phase, Exception suppressedException) {
        try {
            phase.run();
        }
        catch (Exception e) {
            if (suppressedException != null) {
                e.addSuppressed(suppressedException);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(() -> new ParameterizedMessage("Failed to execute [{}] while moving to second phase", (Object)this.request), (Throwable)e);
            }
            this.raiseEarlyFailure(new ReduceSearchPhaseException(phaseName, "", e, this.buildShardFailures()));
        }
    }

    private void onInitialPhaseResult(int shardIndex, @Nullable ShardRouting shard, @Nullable String nodeId, ShardIterator shardIt, Exception e) {
        SearchShardTarget shardTarget = new SearchShardTarget(nodeId, shardIt.shardId());
        this.addShardFailure(shardIndex, shardTarget, e);
        if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
            if (this.logger.isDebugEnabled()) {
                if (e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.logger.debug(() -> new ParameterizedMessage("{}: Failed to execute [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), (Object)this.request), (Throwable)e);
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}]", (Object)shard, (Object)this.request), (Throwable)e);
                }
            }
            ShardSearchFailure[] shardSearchFailures = this.buildShardFailures();
            if (this.successfulOps.get() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(() -> new ParameterizedMessage("All shards failed for phase: [{}]", (Object)this.initialPhaseName()), (Throwable)e);
                }
                this.raiseEarlyFailure(new SearchPhaseExecutionException(this.initialPhaseName(), "all shards failed", e, shardSearchFailures));
            } else {
                this.executePhase(this.initialPhaseName(), this.innerGetNextPhase(), e);
            }
        } else {
            ShardRouting nextShard = shardIt.nextOrNull();
            boolean lastShard = nextShard == null;
            this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard), (Throwable)e);
            if (!lastShard) {
                try {
                    this.performInitialPhase(shardIndex, shardIt, nextShard);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    this.onInitialPhaseResult(shardIndex, shard, shard.currentNodeId(), shardIt, inner);
                }
            } else if (this.logger.isDebugEnabled() && !this.logger.isTraceEnabled() && e != null && !TransportActions.isShardNotAvailableException(e)) {
                this.logger.debug(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard), (Throwable)e);
            }
        }
    }

    protected final ShardSearchFailure[] buildShardFailures() {
        AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures;
        if (shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List<AtomicArray.Entry<ShardSearchFailure>> entries = shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = (ShardSearchFailure)entries.get((int)i).value;
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addShardFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        ShardSearchFailure failure;
        if (TransportActions.isShardNotAvailableException(e)) {
            return;
        }
        if (this.shardFailures == null) {
            Object object = this.shardFailuresMutex;
            synchronized (object) {
                if (this.shardFailures == null) {
                    this.shardFailures = new AtomicArray(this.shardsIts.size());
                }
            }
        }
        if ((failure = this.shardFailures.get(shardIndex)) == null) {
            this.shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
        } else if (TransportActions.isReadOverrideException(e)) {
            this.shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
        }
    }

    private void raiseEarlyFailure(Exception e) {
        for (AtomicArray.Entry<FirstResult> entry : this.initialResults.asList()) {
            try {
                Transport.Connection connection = this.nodeIdToConnection.apply(((SearchPhaseResult)entry.value).shardTarget().getNodeId());
                this.sendReleaseSearchContext(((SearchPhaseResult)entry.value).id(), connection);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.trace("failed to release context", (Throwable)inner);
            }
        }
        this.listener.onFailure(e);
    }

    protected void sendReleaseSearchContext(long contextId, Transport.Connection connection) {
        if (connection != null) {
            this.searchTransportService.sendFreeContext(connection, contextId, this.request);
        }
    }

    protected ShardFetchSearchRequest createFetchRequest(QuerySearchResult queryResult, int index, IntArrayList entry, ScoreDoc[] lastEmittedDocPerShard) {
        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard != null ? lastEmittedDocPerShard[index] : null;
        return new ShardFetchSearchRequest(this.request, queryResult.id(), entry, lastEmittedDoc);
    }

    protected abstract void sendExecuteFirstPhase(Transport.Connection var1, ShardSearchTransportRequest var2, ActionListener<FirstResult> var3);

    protected final void processFirstPhaseResult(int shardIndex, FirstResult result) {
        AtomicArray<ShardSearchFailure> shardFailures;
        this.initialResults.set(shardIndex, result);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("got first-phase result from {}", (Object)(result != null ? result.shardTarget() : null));
        }
        if ((shardFailures = this.shardFailures) != null) {
            shardFailures.set(shardIndex, null);
        }
    }

    final CheckedRunnable<Exception> innerGetNextPhase() {
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            boolean hadOne = false;
            for (int i = 0; i < this.initialResults.length(); ++i) {
                SearchPhaseResult result = (SearchPhaseResult)this.initialResults.get(i);
                if (result == null) continue;
                if (hadOne) {
                    sb.append(",");
                } else {
                    hadOne = true;
                }
                sb.append(result.shardTarget());
            }
            this.logger.trace("Moving to second phase, based on results from: {} (cluster state version: {})", (Object)sb, (Object)this.clusterStateVersion);
        }
        return this.getNextPhase(this.initialResults);
    }

    protected abstract CheckedRunnable<Exception> getNextPhase(AtomicArray<FirstResult> var1);

    protected abstract String initialPhaseName();

    protected Executor getExecutor() {
        return this.executor;
    }

    final void sendResponseAsync(final String phase, final SearchPhaseController searchPhaseController, final ScoreDoc[] sortedDocs, final AtomicArray<? extends QuerySearchResultProvider> queryResultsArr, final AtomicArray<? extends QuerySearchResultProvider> fetchResultsArr) {
        this.getExecutor().execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                boolean isScrollRequest = AbstractSearchAsyncAction.this.request.scroll() != null;
                InternalSearchResponse internalResponse = searchPhaseController.merge(isScrollRequest, sortedDocs, queryResultsArr, fetchResultsArr);
                String scrollId = isScrollRequest ? TransportSearchHelper.buildScrollId(queryResultsArr) : null;
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, AbstractSearchAsyncAction.this.expectedSuccessfulOps, AbstractSearchAsyncAction.this.successfulOps.get(), AbstractSearchAsyncAction.this.buildTookInMillis(), AbstractSearchAsyncAction.this.buildShardFailures()));
            }

            @Override
            public void onFailure(Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException(phase, "", e, AbstractSearchAsyncAction.this.buildShardFailures());
                if (AbstractSearchAsyncAction.this.logger.isDebugEnabled()) {
                    AbstractSearchAsyncAction.this.logger.debug("failed to reduce search", (Throwable)failure);
                }
                super.onFailure(failure);
            }
        });
    }

    final class FetchPhase
    implements CheckedRunnable<Exception> {
        private final AtomicArray<FetchSearchResult> fetchResults;
        private final SearchPhaseController searchPhaseController;
        private final AtomicArray<QuerySearchResultProvider> queryResults;

        FetchPhase(AtomicArray<QuerySearchResultProvider> queryResults, SearchPhaseController searchPhaseController) {
            this.fetchResults = new AtomicArray(queryResults.length());
            this.searchPhaseController = searchPhaseController;
            this.queryResults = queryResults;
        }

        @Override
        public void run() throws Exception {
            boolean isScrollRequest = AbstractSearchAsyncAction.this.request.scroll() != null;
            ScoreDoc[] sortedShardDocs = this.searchPhaseController.sortDocs(isScrollRequest, this.queryResults);
            if (this.queryResults.length() == 1) {
                assert (this.queryResults.get(0) == null || this.queryResults.get(0).fetchResult() != null);
                AbstractSearchAsyncAction.this.sendResponseAsync("fetch", this.searchPhaseController, sortedShardDocs, this.queryResults, this.queryResults);
            } else {
                IntArrayList[] docIdsToLoad = this.searchPhaseController.fillDocIdsToLoad(this.queryResults.length(), sortedShardDocs);
                IntConsumer finishPhase = successOpts -> AbstractSearchAsyncAction.this.sendResponseAsync("fetch", this.searchPhaseController, sortedShardDocs, this.queryResults, this.fetchResults);
                if (sortedShardDocs.length == 0) {
                    this.queryResults.asList().stream().map(e -> ((QuerySearchResultProvider)e.value).queryResult()).forEach(this::releaseIrrelevantSearchContext);
                    finishPhase.accept(AbstractSearchAsyncAction.this.successfulOps.get());
                } else {
                    ScoreDoc[] lastEmittedDocPerShard = isScrollRequest ? this.searchPhaseController.getLastEmittedDocPerShard(this.queryResults.asList(), sortedShardDocs, this.queryResults.length()) : null;
                    CountedCollector<FetchSearchResult> counter = new CountedCollector<FetchSearchResult>(this.fetchResults, docIdsToLoad.length, finishPhase);
                    for (int i = 0; i < docIdsToLoad.length; ++i) {
                        IntArrayList entry = docIdsToLoad[i];
                        QuerySearchResultProvider queryResult = this.queryResults.get(i);
                        if (entry == null) {
                            if (queryResult != null) {
                                this.releaseIrrelevantSearchContext(queryResult.queryResult());
                            }
                            counter.countDown();
                            continue;
                        }
                        Transport.Connection connection = AbstractSearchAsyncAction.this.nodeIdToConnection.apply(queryResult.shardTarget().getNodeId());
                        ShardFetchSearchRequest fetchSearchRequest = AbstractSearchAsyncAction.this.createFetchRequest(queryResult.queryResult(), i, entry, lastEmittedDocPerShard);
                        this.executeFetch(i, queryResult.shardTarget(), counter, fetchSearchRequest, queryResult.queryResult(), connection);
                    }
                }
            }
        }

        private void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final CountedCollector<FetchSearchResult> counter, final ShardFetchSearchRequest fetchSearchRequest, final QuerySearchResult querySearchResult, Transport.Connection connection) {
            AbstractSearchAsyncAction.this.searchTransportService.sendExecuteFetch(connection, fetchSearchRequest, AbstractSearchAsyncAction.this.task, new ActionListener<FetchSearchResult>(){

                @Override
                public void onResponse(FetchSearchResult result) {
                    counter.onResult(shardIndex, result, shardTarget);
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        if (AbstractSearchAsyncAction.this.logger.isDebugEnabled()) {
                            AbstractSearchAsyncAction.this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute fetch phase", (Object)fetchSearchRequest.id()), (Throwable)e);
                        }
                        counter.onFailure(shardIndex, shardTarget, e);
                    }
                    finally {
                        FetchPhase.this.releaseIrrelevantSearchContext(querySearchResult);
                    }
                }
            });
        }

        private void releaseIrrelevantSearchContext(QuerySearchResult queryResult) {
            if (AbstractSearchAsyncAction.this.request.scroll() == null && queryResult.hasHits()) {
                try {
                    Transport.Connection connection = AbstractSearchAsyncAction.this.nodeIdToConnection.apply(queryResult.shardTarget().getNodeId());
                    AbstractSearchAsyncAction.this.sendReleaseSearchContext(queryResult.id(), connection);
                }
                catch (Exception e) {
                    AbstractSearchAsyncAction.this.logger.trace("failed to release context", (Throwable)e);
                }
            }
        }
    }

    final class CountedCollector<R extends SearchPhaseResult> {
        private final AtomicArray<R> resultArray;
        private final CountDown counter;
        private final IntConsumer onFinish;

        CountedCollector(AtomicArray<R> resultArray, int expectedOps, IntConsumer onFinish) {
            this.resultArray = resultArray;
            this.counter = new CountDown(expectedOps);
            this.onFinish = onFinish;
        }

        void countDown() {
            if (this.counter.countDown()) {
                this.onFinish.accept(AbstractSearchAsyncAction.this.successfulOps.get());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(int index, R result, SearchShardTarget target) {
            try {
                result.shardTarget(target);
                this.resultArray.set(index, result);
            }
            finally {
                this.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
            try {
                AbstractSearchAsyncAction.this.addShardFailure(shardIndex, shardTarget, e);
            }
            finally {
                AbstractSearchAsyncAction.this.successfulOps.decrementAndGet();
                this.countDown();
            }
        }
    }
}

