/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoCircleFactory;
import org.apache.lucene.spatial3d.geom.GeoCompositePolygon;
import org.apache.lucene.spatial3d.geom.GeoPath;
import org.apache.lucene.spatial3d.geom.GeoPathFactory;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.GeoPolygonFactory;
import org.apache.lucene.spatial3d.geom.PlanetModel;

class Geo3DUtil {
    static final double RADIANS_PER_METER = 1.5696101447687295E-7;
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    private static final double MAX_VALUE = PlanetModel.WGS84.getMaximumMagnitude();
    private static final int BITS = 32;
    private static final double MUL = 4.294967296E9 / (2.0 * MAX_VALUE);
    static final double DECODE = Geo3DUtil.getNextSafeDouble(1.0 / MUL);
    static final int MIN_ENCODED_VALUE = Geo3DUtil.encodeValue(-MAX_VALUE);
    static final int MAX_ENCODED_VALUE = Geo3DUtil.encodeValue(MAX_VALUE);

    Geo3DUtil() {
    }

    public static int encodeValue(double x) {
        if (x > MAX_VALUE) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (greater than WGS84's planetMax=" + MAX_VALUE + ")");
        }
        if (x < -MAX_VALUE) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (less than than WGS84's -planetMax=" + -MAX_VALUE + ")");
        }
        long result = (long)Math.floor(x / DECODE);
        assert (result >= Integer.MIN_VALUE);
        assert (result <= Integer.MAX_VALUE);
        return (int)result;
    }

    public static double decodeValue(int x) {
        double result = x == MIN_ENCODED_VALUE ? -MAX_VALUE : (x == MAX_ENCODED_VALUE ? MAX_VALUE : ((double)x + 0.5) * DECODE);
        assert (result >= -MAX_VALUE && result <= MAX_VALUE);
        return result;
    }

    static double decodeValueFloor(int x) {
        return (double)x * DECODE;
    }

    private static double getNextSafeDouble(double x) {
        long bits = Double.doubleToLongBits(x);
        bits += Integer.MAX_VALUE;
        double result = Double.longBitsToDouble(bits &= Integer.MIN_VALUE);
        assert (result > x);
        return result;
    }

    static double decodeValueCeil(int x) {
        assert (x < Integer.MAX_VALUE);
        return Math.nextDown((double)(x + 1) * DECODE);
    }

    static double fromDegrees(double degrees) {
        return degrees * (Math.PI / 180);
    }

    static double fromMeters(double meters) {
        return meters * 1.5696101447687295E-7;
    }

    static GeoPolygon fromPolygon(Polygon ... polygons) {
        GeoPolygon shape;
        if (polygons.length < 1) {
            throw new IllegalArgumentException("need at least one polygon");
        }
        if (polygons.length == 1) {
            GeoPolygon component = Geo3DUtil.fromPolygon(polygons[0]);
            shape = component == null ? new GeoCompositePolygon() : component;
        } else {
            GeoCompositePolygon poly = new GeoCompositePolygon();
            for (Polygon p : polygons) {
                GeoPolygon component = Geo3DUtil.fromPolygon(p);
                if (component == null) continue;
                poly.addShape(component);
            }
            shape = poly;
        }
        return shape;
    }

    static GeoPolygon fromLargePolygon(Polygon ... polygons) {
        if (polygons.length < 1) {
            throw new IllegalArgumentException("need at least one polygon");
        }
        return GeoPolygonFactory.makeLargeGeoPolygon(PlanetModel.WGS84, Geo3DUtil.convertToDescription(polygons));
    }

    static GeoPath fromPath(double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters) {
        if (pathLatitudes.length != pathLongitudes.length) {
            throw new IllegalArgumentException("same number of latitudes and longitudes required");
        }
        GeoPoint[] points = new GeoPoint[pathLatitudes.length];
        for (int i = 0; i < pathLatitudes.length; ++i) {
            double latitude = pathLatitudes[i];
            double longitude = pathLongitudes[i];
            GeoUtils.checkLatitude(latitude);
            GeoUtils.checkLongitude(longitude);
            points[i] = new GeoPoint(PlanetModel.WGS84, Geo3DUtil.fromDegrees(latitude), Geo3DUtil.fromDegrees(longitude));
        }
        return GeoPathFactory.makeGeoPath(PlanetModel.WGS84, Geo3DUtil.fromMeters(pathWidthMeters), points);
    }

    static GeoCircle fromDistance(double latitude, double longitude, double radiusMeters) {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        return GeoCircleFactory.makeGeoCircle(PlanetModel.WGS84, Geo3DUtil.fromDegrees(latitude), Geo3DUtil.fromDegrees(longitude), Geo3DUtil.fromMeters(radiusMeters));
    }

    static GeoBBox fromBox(double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoUtils.checkLatitude(minLatitude);
        GeoUtils.checkLongitude(minLongitude);
        GeoUtils.checkLatitude(maxLatitude);
        GeoUtils.checkLongitude(maxLongitude);
        return GeoBBoxFactory.makeGeoBBox(PlanetModel.WGS84, Geo3DUtil.fromDegrees(maxLatitude), Geo3DUtil.fromDegrees(minLatitude), Geo3DUtil.fromDegrees(minLongitude), Geo3DUtil.fromDegrees(maxLongitude));
    }

    private static GeoPolygon fromPolygon(Polygon polygon) {
        Polygon[] theHoles = polygon.getHoles();
        ArrayList<GeoPolygon> holeList = new ArrayList<GeoPolygon>(theHoles.length);
        for (Polygon hole : theHoles) {
            GeoPolygon component = Geo3DUtil.fromPolygon(hole);
            if (component == null) continue;
            holeList.add(component);
        }
        double[] polyLats = polygon.getPolyLats();
        double[] polyLons = polygon.getPolyLons();
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(polyLats.length - 1);
        for (int i = 0; i < polyLats.length - 1; ++i) {
            int index = polyLats.length - 2 - i;
            points.add(new GeoPoint(PlanetModel.WGS84, Geo3DUtil.fromDegrees(polyLats[index]), Geo3DUtil.fromDegrees(polyLons[index])));
        }
        GeoPolygon rval = GeoPolygonFactory.makeGeoPolygon(PlanetModel.WGS84, points, holeList);
        return rval;
    }

    private static List<GeoPolygonFactory.PolygonDescription> convertToDescription(Polygon ... polygons) {
        ArrayList<GeoPolygonFactory.PolygonDescription> descriptions = new ArrayList<GeoPolygonFactory.PolygonDescription>(polygons.length);
        for (Polygon polygon : polygons) {
            Polygon[] theHoles = polygon.getHoles();
            List<GeoPolygonFactory.PolygonDescription> holes = Geo3DUtil.convertToDescription(theHoles);
            double[] polyLats = polygon.getPolyLats();
            double[] polyLons = polygon.getPolyLons();
            ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(polyLats.length - 1);
            for (int i = 0; i < polyLats.length - 1; ++i) {
                int index = polyLats.length - 2 - i;
                points.add(new GeoPoint(PlanetModel.WGS84, Geo3DUtil.fromDegrees(polyLats[index]), Geo3DUtil.fromDegrees(polyLons[index])));
            }
            descriptions.add(new GeoPolygonFactory.PolygonDescription(points, holes));
        }
        return descriptions;
    }
}

