/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.SloppyMath;
import org.apache.lucene.util.StringHelper;

final class LatLonPointDistanceQuery
extends Query {
    final String field;
    final double latitude;
    final double longitude;
    final double radiusMeters;

    public LatLonPointDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        Rectangle box = Rectangle.fromPointDistance(this.latitude, this.longitude, this.radiusMeters);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        final byte[] minLon2 = new byte[4];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box.minLat), minLat, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box.maxLat), maxLat, 0);
        if (box.crossesDateline()) {
            NumericUtils.intToSortableBytes(Integer.MIN_VALUE, minLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.maxLon), maxLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.minLon), minLon2, 0);
        } else {
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.minLon), minLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.maxLon), maxLon, 0);
            NumericUtils.intToSortableBytes(Integer.MAX_VALUE, minLon2, 0);
        }
        final double sortKey = GeoUtils.distanceQuerySortKey(this.radiusMeters);
        final double axisLat = Rectangle.axisLat(this.latitude, this.radiusMeters);
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointDistanceQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonPointDistanceQuery.this.field);
                values.intersect(LatLonPointDistanceQuery.this.field, new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        double docLongitude;
                        if (StringHelper.compare(4, packedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, packedValue, 0, minLat, 0) < 0) {
                            return;
                        }
                        if ((StringHelper.compare(4, packedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, packedValue, 4, minLon, 0) < 0) && StringHelper.compare(4, packedValue, 4, minLon2, 0) < 0) {
                            return;
                        }
                        double docLatitude = GeoEncodingUtils.decodeLatitude(packedValue, 0);
                        if (SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, docLatitude, docLongitude = GeoEncodingUtils.decodeLongitude(packedValue, 4)) <= sortKey) {
                            this.adder.add(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare(4, minPackedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, maxPackedValue, 0, minLat, 0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if ((StringHelper.compare(4, minPackedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, maxPackedValue, 4, minLon, 0) < 0) && StringHelper.compare(4, maxPackedValue, 4, minLon2, 0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        double latMin = GeoEncodingUtils.decodeLatitude(minPackedValue, 0);
                        double lonMin = GeoEncodingUtils.decodeLongitude(minPackedValue, 4);
                        double latMax = GeoEncodingUtils.decodeLatitude(maxPackedValue, 0);
                        double lonMax = GeoEncodingUtils.decodeLongitude(maxPackedValue, 4);
                        if ((LatLonPointDistanceQuery.this.longitude < lonMin || LatLonPointDistanceQuery.this.longitude > lonMax) && (axisLat + 8.993203677616636E-7 < latMin || axisLat - 8.993203677616636E-7 > latMax) && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMin, lonMin) > sortKey && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMin, lonMax) > sortKey && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMax, lonMin) > sortKey && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMax, lonMax) > sortKey) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if (lonMax - LatLonPointDistanceQuery.this.longitude < 90.0 && LatLonPointDistanceQuery.this.longitude - lonMin < 90.0 && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMin, lonMin) <= sortKey && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMin, lonMax) <= sortKey && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMax, lonMin) <= sortKey && SloppyMath.haversinSortKey(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, latMax, lonMax) <= sortKey) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointDistanceQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(LatLonPointDistanceQuery other) {
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }
}

