/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchReference;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedSearchOperation;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSearchReference
extends InterceptedOperation
implements InMemoryInterceptedSearchReference {
    private final ReadOnlySearchRequest searchRequest;
    private SearchResultReference reference;

    InterceptedSearchReference(InterceptedSearchOperation op, SearchResultReferenceProtocolOp reference, Control ... requestControls) {
        super(op);
        this.searchRequest = op.getRequest();
        this.reference = reference.toSearchResultReference(requestControls);
    }

    public ReadOnlySearchRequest getRequest() {
        return this.searchRequest;
    }

    public SearchResultReference getSearchReference() {
        return this.reference;
    }

    public void setSearchReference(SearchResultReference reference) {
        this.reference = reference;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("InterceptedSearchReference(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.searchRequest);
        buffer.append(", reference=");
        buffer.append(this.reference);
        buffer.append(')');
    }
}

