/*
 * Decompiled with CFR 0.152.
 */
package com.ucloudlink.css.main;

import com.ucloudlink.css.common.DataSourceUtil;
import com.ucloudlink.css.elasticsearch.http.ElasticsearchHttpFactory;
import com.ucloudlink.css.elasticsearch.transport.ElasticsearchTransportFactory;
import com.ucloudlink.css.util.DateUtil;
import com.ucloudlink.css.util.NumberUtil;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.fastjson.JSON;
import org.elasticsearch.fastjson.JSONObject;
import org.elasticsearch.log4j.LogManager;
import org.elasticsearch.log4j.Logger;

public class Main {
    private static Logger logger = LogManager.getLogger();
    private static ElasticsearchTransportFactory tfactory = DataSourceUtil.transportElasticsearch();
    private static ElasticsearchHttpFactory hfactory = DataSourceUtil.httpElasticsearch();
    private static int ACCESS_TYPE = 0;
    private static AtomicInteger atomic = new AtomicInteger(0);

    public static void write(long count) {
        logger.info("--Write Count:" + count);
        long start = System.currentTimeMillis();
        int i = 0;
        while (count < 1L || (long)i < count) {
            Date today = new Date();
            Random random = new Random();
            JSONObject json = new JSONObject();
            json.put("id", (Object)UUIDs.randomBase64UUID());
            json.put("cellId", (Object)random.nextInt(1000));
            json.put("cid", (Object)random.nextInt());
            json.put("devicetype", (Object)random.nextInt(10));
            json.put("iso2", (Object)UUIDs.randomBase64UUID());
            json.put("lac", (Object)random.nextInt(10000));
            json.put("latitude", (Object)random.nextDouble());
            json.put("longitude", (Object)random.nextGaussian());
            json.put("logId", (Object)UUIDs.randomBase64UUID(random));
            json.put("mcc", (Object)460);
            json.put("plmn", (Object)today.getTime());
            json.put("uid", (Object)UUIDs.randomBase64UUID(random));
            json.put("country", (Object)"CN[\u4e2d\u56fd]");
            json.put("province", (Object)"ShannXi[\u9655\u897f]");
            json.put("city", (Object)"Xi'An[\u897f\u5b89]");
            json.put("sessionid", (Object)UUIDs.randomBase64UUID());
            json.put("userCode", (Object)(random.nextInt(1000) + "@ucloudlink.com"));
            json.put("imei", (Object)(1365222 + random.nextInt(1000)));
            json.put("imsi", (Object)(1365222 + random.nextInt(1000)));
            Date beginTime = new Date(today.getTime() + (long)random.nextInt());
            json.put("beginTime", (Object)beginTime);
            json.put("countDay", (Object)today);
            json.put("card", (Object)random.nextInt(100));
            json.put("cardDownFlow", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("cardUpFlow", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("sys", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("sysDownFlow", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("sysUpFlow", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("userDownFlow", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("userUpFlow", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            json.put("user", (Object)(random.nextDouble() * 1000.0 * 1000.0));
            String description = "[" + DateUtil.formatDateTimeStr(beginTime) + "]Elasticsearch \u662f\u4e00\u4e2a\u5206\u5e03\u5f0f\u53ef\u6269\u5c55\u7684\u5b9e\u65f6\u641c\u7d22\u548c\u5206\u6790\u5f15\u64ce\u3002\u5b83\u80fd\u5e2e\u52a9\u4f60\u641c\u7d22\u3001\u5206\u6790\u548c\u6d4f\u89c8\u6570\u636e\uff0c\u800c\u5f80\u5f80\u5927\u5bb6\u5e76\u6ca1\u6709\u5728\u67d0\u4e2a\u9879\u76ee\u4e00\u5f00\u59cb\u5c31\u9884\u6599\u5230\u9700\u8981\u8fd9\u4e9b\u529f\u80fd\u3002Elasticsearch \u4e4b\u6240\u4ee5\u51fa\u73b0\u5c31\u662f\u4e3a\u4e86\u91cd\u65b0\u8d4b\u4e88\u786c\u76d8\u4e2d\u770b\u4f3c\u65e0\u7528\u7684\u539f\u59cb\u6570\u636e\u65b0\u7684\u6d3b\u529b\u3002Elasticsearch \u4e3a\u5f88\u591a\u4e16\u754c\u6d41\u884c\u8bed\u8a00\u63d0\u4f9b\u826f\u597d\u7684\u3001\u7b80\u5355\u7684\u3001\u5f00\u7bb1\u5373\u7528\u7684\u8bed\u8a00\u5206\u6790\u5668\u96c6\u5408\uff1a\u963f\u62c9\u4f2f\u8bed\u3001\u4e9a\u7f8e\u5c3c\u4e9a\u8bed\u3001\u5df4\u65af\u514b\u8bed\u3001\u5df4\u897f\u8bed\u3001\u4fdd\u52a0\u5229\u4e9a\u8bed\u3001\u52a0\u6cf0\u7f57\u5c3c\u4e9a\u8bed\u3001\u4e2d\u6587\u3001\u6377\u514b\u8bed\u3001\u4e39\u9ea6\u3001\u8377\u5170\u8bed\u3001\u82f1\u8bed\u3001\u82ac\u5170\u8bed\u3001\u6cd5\u8bed\u3001\u52a0\u91cc\u897f\u4e9a\u8bed\u3001\u5fb7\u8bed\u3001\u5e0c\u814a\u8bed\u3001\u5317\u5370\u5ea6\u8bed\u3001\u5308\u7259\u5229\u8bed\u3001\u5370\u5ea6\u5c3c\u897f\u4e9a\u3001\u7231\u5c14\u5170\u8bed\u3001\u610f\u5927\u5229\u8bed\u3001\u65e5\u8bed\u3001\u97e9\u56fd\u8bed\u3001\u5e93\u5c14\u5fb7\u8bed\u3001\u632a\u5a01\u8bed\u3001\u6ce2\u65af\u8bed\u3001\u8461\u8404\u7259\u8bed\u3001\u7f57\u9a6c\u5c3c\u4e9a\u8bed\u3001\u4fc4\u8bed\u3001\u897f\u73ed\u7259\u8bed\u3001\u745e\u5178\u8bed\u3001\u571f\u8033\u5176\u8bed\u548c\u6cf0\u8bed";
            json.put("description", (Object)description);
            String result = "";
            if (ACCESS_TYPE == 0) {
                result = tfactory.insert("tcdr", "test", json.toJSONString());
            }
            if (ACCESS_TYPE == 1) {
                result = hfactory.insert("hcdr", "test", json.toJSONString());
            }
            atomic.incrementAndGet();
            long end = System.currentTimeMillis();
            double time = (double)(end - start) / 1000.0;
            if (time >= 100.0) {
                System.exit(1);
            }
            double ss = time % 60.0;
            int mm = Double.valueOf(time / 60.0).intValue() % 60;
            int hh = Double.valueOf(time / 60.0 / 60.0).intValue() % 60;
            logger.info("[" + atomic.get() + "]ES Write \u8017\u65f6:" + (hh > 0 ? hh + "\u5c0f\u65f6" : "") + (mm > 0 ? mm + "\u5206\u949f" : "") + ss + "\u79d2-------------" + result);
            ++i;
        }
    }

    public static void read(long count) {
        logger.info("--Read Count:" + count);
        long start = System.currentTimeMillis();
        int i = 0;
        while (count < 1L || (long)i < count) {
            String query = "Elasticsearch \u8bed\u8a00\u5206\u6790\u5668 \u4e2d\u6587 \u897f\u5b89";
            String result = "";
            if (ACCESS_TYPE == 0) {
                result = tfactory.selectAll("test", "cdr", query);
            }
            if (ACCESS_TYPE == 1) {
                result = hfactory.selectAll("test", "cdr", query);
            }
            atomic.incrementAndGet();
            long end = System.currentTimeMillis();
            double time = (double)(end - start) / 1000.0;
            if (time >= 100.0) {
                System.exit(1);
            }
            double ss = time % 60.0;
            int mm = Double.valueOf(time / 60.0).intValue() % 60;
            int hh = Double.valueOf(time / 60.0 / 60.0).intValue() % 60;
            logger.info("[" + atomic.get() + "]ES Read \u8017\u65f6:" + (hh > 0 ? hh + "\u5c0f\u65f6" : "") + (mm > 0 ? mm + "\u5206\u949f" : "") + ss + "\u79d2-------------" + result.length());
            ++i;
        }
    }

    public static void thread(final long count, final String opt, int thread, int type) {
        ACCESS_TYPE = type;
        int cpu = Runtime.getRuntime().availableProcessors();
        for (int i = 0; thread < 1 || i < thread; ++i) {
            Thread service = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (opt.equalsIgnoreCase("r")) {
                        Main.read(count);
                    } else {
                        Main.write(count);
                    }
                }
            });
            service.setName(cpu + "-Elasticsearch-Thread-" + i);
            service.start();
        }
    }

    public static void execute(final long count, final String opt, int thread, int type) {
        ACCESS_TYPE = type;
        ExecutorService service = Executors.newSingleThreadExecutor();
        if (thread > 1) {
            service = Executors.newFixedThreadPool(thread);
        } else if (thread < 1) {
            service = Executors.newCachedThreadPool();
        }
        for (int i = 0; thread < 1 || i < thread; ++i) {
            service.submit(new Runnable(){

                @Override
                public void run() {
                    if (opt.equalsIgnoreCase("r")) {
                        Main.read(count);
                    } else {
                        Main.write(count);
                    }
                }
            });
        }
    }

    public static void main(String[] args) {
        long count = args != null && args.length > 1 && NumberUtil.isNumber(args[0]) ? Long.valueOf(args[0]) : 0L;
        String opt = args != null && args.length > 2 && args[1].equalsIgnoreCase("r") ? "r" : "w";
        int thread = args != null && args.length > 3 && NumberUtil.isNumber(args[2]) ? Integer.valueOf(args[2]) : 1;
        int type = args != null && args.length > 4 && NumberUtil.isNumber(args[3]) ? Integer.valueOf(args[3]) : 0;
        logger.info("--{count:" + count + ",opt:" + opt + ",thread:" + thread + ",type:" + type + "[0.Transport,1.HTTP,2.Rest]}--" + JSON.toJSONString(args));
        if (args != null && args.length > 5) {
            Main.execute(count, opt, thread, type);
        } else {
            Main.thread(count, opt, thread, type);
        }
    }
}

