/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.senders;

import com.twitter.zipkin.thriftjava.Span;
import com.uber.jaeger.agent.thrift.Agent;
import com.uber.jaeger.exceptions.SenderException;
import com.uber.jaeger.reporters.protocols.TUDPTransport;
import com.uber.jaeger.senders.Sender;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TTransport;

public class UDPSender
implements Sender {
    static final int emitZipkinBatchOverhead = 22;
    private static final String defaultUDPSpanServerHost = "localhost";
    private static final int defaultUDPSpanServerPort = 5775;
    private static final int defaultUDPPacketSize = 65000;
    private int maxSpanBytes;
    private Agent.Client udpClient;
    private List<Span> spanBuffer;
    private int byteBufferSize;
    private AutoExpandingBufferWriteTransport memoryTransport;
    private TUDPTransport udpTransport;

    public UDPSender(String host, int port, int maxPacketSize) {
        if (host == null || host.length() == 0) {
            host = defaultUDPSpanServerHost;
        }
        if (port == 0) {
            port = 5775;
        }
        if (maxPacketSize == 0) {
            maxPacketSize = 65000;
        }
        this.memoryTransport = new AutoExpandingBufferWriteTransport(maxPacketSize, 2.0);
        this.udpTransport = TUDPTransport.NewTUDPClient(host, port);
        this.udpClient = new Agent.Client((TProtocol)new TCompactProtocol((TTransport)this.udpTransport));
        this.maxSpanBytes = maxPacketSize - 22;
        this.spanBuffer = new ArrayList<Span>();
    }

    int getSizeOfSerializedSpan(Span span) throws SenderException {
        this.memoryTransport.reset();
        try {
            span.write((TProtocol)new TCompactProtocol((TTransport)this.memoryTransport));
        }
        catch (TException e) {
            throw new SenderException("UDPSender failed writing to memory buffer.", e, 1);
        }
        return this.memoryTransport.getPos();
    }

    @Override
    public int append(Span span) throws SenderException {
        int n;
        int spanSize = this.getSizeOfSerializedSpan(span);
        if (spanSize > this.maxSpanBytes) {
            throw new SenderException("UDPSender received a span that was too large", null, 1);
        }
        this.byteBufferSize += spanSize;
        if (this.byteBufferSize <= this.maxSpanBytes) {
            this.spanBuffer.add(span);
            if (this.byteBufferSize < this.maxSpanBytes) {
                return 0;
            }
            return this.flush();
        }
        try {
            n = this.flush();
        }
        catch (SenderException e) {
            throw new SenderException(e.getMessage(), e.getCause(), e.getDroppedSpanCount() + 1);
        }
        this.spanBuffer.add(span);
        this.byteBufferSize = spanSize;
        return n;
    }

    @Override
    public int flush() throws SenderException {
        if (this.spanBuffer.isEmpty()) {
            return 0;
        }
        int n = this.spanBuffer.size();
        try {
            this.udpClient.emitZipkinBatch(this.spanBuffer);
        }
        catch (TException e) {
            throw new SenderException("Failed to flush spans.", e, n);
        }
        finally {
            this.spanBuffer.clear();
            this.byteBufferSize = 0;
        }
        return n;
    }

    @Override
    public int close() throws SenderException {
        int n = this.flush();
        this.udpTransport.close();
        return n;
    }

    public String toString() {
        return "UDPSender(maxSpanBytes=" + this.maxSpanBytes + ", byteBufferSize=" + this.byteBufferSize + ", udpTransport=" + this.udpTransport + ")";
    }
}

