/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.samplers.SamplingStatus;
import com.uber.jaeger.utils.RateLimiter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RateLimitingSampler
implements Sampler {
    public static final String TYPE = "ratelimiting";
    private final RateLimiter rateLimiter;
    private final double maxTracesPerSecond;
    private final Map<String, Object> tags;

    public RateLimitingSampler(double maxTracesPerSecond) {
        this.maxTracesPerSecond = maxTracesPerSecond;
        double maxBalance = maxTracesPerSecond < 1.0 ? 1.0 : maxTracesPerSecond;
        this.rateLimiter = new RateLimiter(maxTracesPerSecond, maxBalance);
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put("sampler.type", TYPE);
        tags.put("sampler.param", maxTracesPerSecond);
        this.tags = Collections.unmodifiableMap(tags);
    }

    @Override
    public SamplingStatus sample(String operation, long id) {
        return SamplingStatus.of(this.rateLimiter.checkCredit(1.0), this.tags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RateLimitingSampler) {
            return this.maxTracesPerSecond == ((RateLimitingSampler)other).maxTracesPerSecond;
        }
        return false;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "RateLimitingSampler(maxTracesPerSecond=" + this.getMaxTracesPerSecond() + ", tags=" + this.tags + ")";
    }

    public double getMaxTracesPerSecond() {
        return this.maxTracesPerSecond;
    }
}

