/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters.protocols;

import com.uber.jaeger.LogData;
import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.thriftjava.Log;
import com.uber.jaeger.thriftjava.Tag;
import com.uber.jaeger.thriftjava.TagType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JaegerThriftSpanConverter {
    public static com.uber.jaeger.thriftjava.Span convertSpan(Span span) {
        SpanContext context = span.context();
        return new com.uber.jaeger.thriftjava.Span(context.getTraceID(), 0L, context.getSpanID(), context.getParentID(), span.getOperationName(), (int)context.getFlags(), span.getStart(), span.getDuration()).setTags(JaegerThriftSpanConverter.buildTags(span.getTags())).setLogs(JaegerThriftSpanConverter.buildLogs(span.getLogs()));
    }

    protected static List<Log> buildLogs(List<LogData> logs) {
        ArrayList<Log> jLogs = new ArrayList<Log>();
        if (logs != null) {
            for (LogData logData : logs) {
                Log jLog = new Log();
                jLog.setTimestamp(logData.getTime());
                if (logData.getFields() != null) {
                    jLog.setFields(JaegerThriftSpanConverter.buildTags(logData.getFields()));
                } else {
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    if (logData.getMessage() != null) {
                        tags.add(JaegerThriftSpanConverter.buildTag("event", logData.getMessage()));
                    }
                    if (logData.getPayload() != null) {
                        tags.add(JaegerThriftSpanConverter.buildTag("payload", logData.getPayload()));
                    }
                    jLog.setFields(tags);
                }
                jLogs.add(jLog);
            }
        }
        return jLogs;
    }

    protected static List<Tag> buildTags(Map<String, ?> tags) {
        ArrayList<Tag> jTags = new ArrayList<Tag>();
        if (tags != null) {
            for (Map.Entry<String, ?> entry : tags.entrySet()) {
                String tagKey = entry.getKey();
                Object tagValue = entry.getValue();
                jTags.add(JaegerThriftSpanConverter.buildTag(tagKey, tagValue));
            }
        }
        return jTags;
    }

    protected static Tag buildTag(String tagKey, Object tagValue) {
        Tag tag = new Tag();
        tag.setKey(tagKey);
        if (tagValue instanceof Integer || tagValue instanceof Short || tagValue instanceof Long) {
            tag.setVType(TagType.LONG);
            tag.setVLong(((Number)tagValue).longValue());
        } else if (tagValue instanceof Double || tagValue instanceof Float) {
            tag.setVType(TagType.DOUBLE);
            tag.setVDouble(((Number)tagValue).doubleValue());
        } else if (tagValue instanceof Boolean) {
            tag.setVType(TagType.BOOL);
            tag.setVBool(((Boolean)tagValue).booleanValue());
        } else {
            JaegerThriftSpanConverter.buildStringTag(tag, tagValue);
        }
        return tag;
    }

    protected static void buildStringTag(Tag tag, Object tagValue) {
        tag.setVType(TagType.STRING);
        String stringTagValue = String.valueOf(tagValue);
        tag.setVStr(JaegerThriftSpanConverter.truncateString(stringTagValue));
    }

    protected static String truncateString(String s) {
        if (s.length() > 256) {
            return s.substring(0, 256);
        }
        return s;
    }
}

