/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters;

import com.uber.jaeger.Span;
import com.uber.jaeger.exceptions.SenderException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.reporters.protocols.ThriftSpanConverter;
import com.uber.jaeger.senders.Sender;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(RemoteReporter.class);
    private final BlockingQueue<Command> commandQueue;
    private final Timer flushTimer;
    private final Thread queueProcessorThread;
    private final QueueProcessor queueProcessor;
    private final Sender sender;
    private final int maxQueueSize;
    private final Metrics metrics;

    public RemoteReporter(Sender sender, int flushInterval, int maxQueueSize, Metrics metrics) {
        this.sender = sender;
        this.maxQueueSize = maxQueueSize;
        this.metrics = metrics;
        this.commandQueue = new ArrayBlockingQueue<Command>(maxQueueSize);
        this.queueProcessor = new QueueProcessor();
        this.queueProcessorThread = new Thread((Runnable)this.queueProcessor, "jaeger.RemoteReporter-QueueProcessor");
        this.queueProcessorThread.setDaemon(true);
        this.queueProcessorThread.start();
        this.flushTimer = new Timer("jaeger.RemoteReporter-FlushTimer", true);
        this.flushTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RemoteReporter.this.commandQueue.add(new FlushCommand());
            }
        }, 0L, (long)flushInterval);
    }

    @Override
    public void report(Span span) {
        if (this.commandQueue.size() == this.maxQueueSize) {
            this.metrics.reporterDropped.inc(1L);
            return;
        }
        this.commandQueue.add(new AppendCommand(ThriftSpanConverter.convertSpan(span)));
    }

    @Override
    public void close() {
        this.commandQueue.add(new CloseCommand());
        try {
            this.queueProcessorThread.join();
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            try {
                int n = this.sender.close();
                this.metrics.reporterSuccess.inc(n);
            }
            catch (SenderException e) {
                this.metrics.reporterFailure.inc(e.getDroppedSpanCount());
            }
            this.flushTimer.cancel();
        }
    }

    public String toString() {
        return "RemoteReporter(queueProcessor=" + this.queueProcessor + ", sender=" + this.sender + ", maxQueueSize=" + this.maxQueueSize + ")";
    }

    class QueueProcessor
    implements Runnable {
        private boolean open = true;

        QueueProcessor() {
        }

        @Override
        public void run() {
            while (this.open) {
                try {
                    Command command = (Command)RemoteReporter.this.commandQueue.take();
                    try {
                        command.execute();
                    }
                    catch (SenderException e) {
                        ((RemoteReporter)RemoteReporter.this).metrics.reporterFailure.inc(e.getDroppedSpanCount());
                    }
                }
                catch (InterruptedException e) {
                    log.error("QueueProcessor error:", (Throwable)e);
                }
            }
        }

        public void close() {
            this.open = false;
        }

        public String toString() {
            return "RemoteReporter.QueueProcessor(open=" + this.open + ")";
        }
    }

    class FlushCommand
    implements Command {
        FlushCommand() {
        }

        @Override
        public void execute() throws SenderException {
            int n = RemoteReporter.this.sender.flush();
            ((RemoteReporter)RemoteReporter.this).metrics.reporterSuccess.inc(n);
            ((RemoteReporter)RemoteReporter.this).metrics.reporterQueueLength.update(RemoteReporter.this.commandQueue.size());
        }
    }

    class CloseCommand
    implements Command {
        CloseCommand() {
        }

        @Override
        public void execute() throws SenderException {
            RemoteReporter.this.queueProcessor.close();
        }
    }

    class AppendCommand
    implements Command {
        private final com.twitter.zipkin.thriftjava.Span span;

        public AppendCommand(com.twitter.zipkin.thriftjava.Span span) {
            this.span = span;
        }

        @Override
        public void execute() throws SenderException {
            RemoteReporter.this.sender.append(this.span);
        }
    }

    public static interface Command {
        public void execute() throws SenderException;
    }
}

