/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.twitter.zipkin.thriftjava.Endpoint;
import com.uber.jaeger.LogData;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Span
implements io.opentracing.Span {
    private final Tracer tracer;
    private final long startTimeMicroseconds;
    private final long startTimeNanoTicks;
    private final boolean computeDurationViaNanoTicks;
    private final Map<String, Object> tags;
    private long durationMicroseconds;
    private String operationName;
    private SpanContext context;
    private Endpoint peer;
    private List<LogData> logs;
    private String localComponent;
    private boolean isClient;
    private boolean isRPC;

    Span(Tracer tracer, String operationName, SpanContext context, long startTimeMicroseconds, long startTimeNanoTicks, boolean computeDurationViaNanoTicks, Map<String, Object> tags) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.context = context;
        this.startTimeMicroseconds = startTimeMicroseconds;
        this.startTimeNanoTicks = startTimeNanoTicks;
        this.computeDurationViaNanoTicks = computeDurationViaNanoTicks;
        this.tags = new HashMap<String, Object>();
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            this.setTagAsObject(tag.getKey(), tag.getValue());
        }
    }

    public String getLocalComponent() {
        return this.localComponent;
    }

    public long getStart() {
        return this.startTimeMicroseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        Span span = this;
        synchronized (span) {
            return this.durationMicroseconds;
        }
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getPeer() {
        Span span = this;
        synchronized (span) {
            return this.peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint getOrMakePeer() {
        Span span = this;
        synchronized (span) {
            if (this.peer == null) {
                this.peer = new Endpoint(0, 0, "");
            }
            return this.peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Span span = this;
        synchronized (span) {
            return Collections.unmodifiableMap(this.tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setOperationName(String operationName) {
        Span span = this;
        synchronized (span) {
            this.operationName = operationName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOperationName() {
        Span span = this;
        synchronized (span) {
            return this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogData> getLogs() {
        Span span = this;
        synchronized (span) {
            if (this.logs == null) {
                return null;
            }
            return Collections.unmodifiableList(this.logs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setBaggageItem(String key, String value) {
        Span span = this;
        synchronized (span) {
            this.context = this.context.withBaggageItem(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaggageItem(String key) {
        Span span = this;
        synchronized (span) {
            return this.context.getBaggageItem(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Span span = this;
        synchronized (span) {
            return this.context.contextAsString() + " - " + this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanContext context() {
        Span span = this;
        synchronized (span) {
            return this.context;
        }
    }

    public void finish() {
        if (this.computeDurationViaNanoTicks) {
            long nanoDuration = this.tracer.clock().currentNanoTicks() - this.startTimeNanoTicks;
            this.finishWithDuration(nanoDuration / 1000L);
        } else {
            this.finish(this.tracer.clock().currentTimeMicros());
        }
    }

    public void finish(long finishMicros) {
        this.finishWithDuration(finishMicros - this.startTimeMicroseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithDuration(long durationMicros) {
        Span span = this;
        synchronized (span) {
            this.durationMicroseconds = durationMicros;
        }
        if (this.context.isSampled()) {
            this.tracer.reportSpan(this);
        }
    }

    public void close() {
        this.finish();
    }

    public synchronized Span setTag(String key, String value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized Span setTag(String key, boolean value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized Span setTag(String key, Number value) {
        return this.setTagAsObject(key, value);
    }

    private boolean handleSpecialTag(String key, Object value) {
        if (key.equals(Tags.COMPONENT.getKey()) && value instanceof String) {
            this.localComponent = (String)value;
            return true;
        }
        if (key.equals(Tags.PEER_HOST_IPV4.getKey()) && value instanceof Integer) {
            this.getOrMakePeer().setIpv4(((Integer)value).intValue());
            return true;
        }
        if (key.equals(Tags.PEER_PORT.getKey()) && value instanceof Number) {
            this.getOrMakePeer().setPort(((Number)value).shortValue());
            return true;
        }
        if (key.equals(Tags.PEER_SERVICE.getKey()) && value instanceof String) {
            this.getOrMakePeer().setService_name((String)value);
            return true;
        }
        if (key.equals(Tags.SPAN_KIND.getKey()) && value instanceof String) {
            this.isClient = "client".equals(value);
            boolean isServer = "server".equals(value);
            this.isRPC = this.isClient || isServer;
            return true;
        }
        return false;
    }

    private Span setTagAsObject(String key, Object value) {
        if (key.equals(Tags.SAMPLING_PRIORITY.getKey()) && value instanceof Number) {
            int priority = ((Number)value).intValue();
            byte newFlags = priority > 0 ? (byte)(this.context.getFlags() | 1 | 2) : (byte)(this.context.getFlags() & 0xFFFFFFFE);
            this.context = this.context.withFlags(newFlags);
        }
        if (this.context.isSampled() && !this.handleSpecialTag(key, value)) {
            this.tags.put(key, value);
        }
        return this;
    }

    public Span log(Map<String, ?> fields) {
        return this.log(this.tracer.clock().currentTimeMicros(), (Map)fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        Span span = this;
        synchronized (span) {
            if (fields == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, fields));
            }
            return this;
        }
    }

    public Span log(String event) {
        return this.log(this.tracer.clock().currentTimeMicros(), event, null);
    }

    public Span log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, event, null);
    }

    public Span log(String message, Object payload) {
        return this.log(this.tracer.clock().currentTimeMicros(), message, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span log(long timestampMicroseconds, String message, Object payload) {
        Span span = this;
        synchronized (span) {
            if (message == null && payload == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, message, payload));
            }
            return this;
        }
    }

    public boolean isRPC() {
        return this.isRPC;
    }

    public boolean isRPCClient() {
        return this.isClient;
    }
}

