/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.testing;

import com.google.common.collect.ObjectArrays;
import com.uber.cadence.TaskList;
import com.uber.cadence.WorkflowExecutionStartedEventAttributes;
import com.uber.cadence.common.WorkflowExecutionHistory;
import com.uber.cadence.internal.common.WorkflowExecutionUtils;
import com.uber.cadence.testing.TestWorkflowEnvironment;
import com.uber.cadence.worker.Worker;
import java.io.File;

public final class WorkflowReplayer {
    public static void replayWorkflowExecutionFromResource(String resourceName, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionUtils.readHistoryFromResource(resourceName);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(File historyFile, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionUtils.readHistory(historyFile);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(String jsonSerializedHistory, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(WorkflowExecutionHistory history, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionStartedEventAttributes attr = history.getEvents().get(0).getWorkflowExecutionStartedEventAttributes();
        TaskList taskList = attr.getTaskList();
        TestWorkflowEnvironment testEnv = TestWorkflowEnvironment.newInstance();
        Worker worker = testEnv.newWorker(taskList.getName());
        worker.registerWorkflowImplementationTypes((Class[])ObjectArrays.concat((Object[])moreWorkflowClasses, workflowClass));
        worker.replayWorkflowExecution(history);
    }
}

