/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.testing;

import com.google.common.annotations.VisibleForTesting;
import com.uber.cadence.client.WorkflowClient;
import com.uber.cadence.client.WorkflowClientOptions;
import com.uber.cadence.internal.sync.TestWorkflowEnvironmentInternal;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.cadence.testing.TestEnvironmentOptions;
import com.uber.cadence.worker.Worker;
import com.uber.cadence.worker.WorkerFactory;
import com.uber.cadence.worker.WorkerOptions;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

@VisibleForTesting
public interface TestWorkflowEnvironment {
    public static TestWorkflowEnvironment newInstance() {
        return new TestWorkflowEnvironmentInternal(null, new TestEnvironmentOptions.Builder().build());
    }

    public static TestWorkflowEnvironment newInstance(TestEnvironmentOptions options) {
        return new TestWorkflowEnvironmentInternal(null, options);
    }

    public static TestWorkflowEnvironment newInstance(TestWorkflowEnvironmentInternal.WorkflowServiceWrapper workflowService, TestEnvironmentOptions options) {
        return new TestWorkflowEnvironmentInternal(workflowService, options);
    }

    public Worker newWorker(String var1);

    public Worker newWorker(String var1, Function<WorkerOptions.Builder, WorkerOptions.Builder> var2);

    public WorkflowClient newWorkflowClient();

    public WorkflowClient newWorkflowClient(WorkflowClientOptions var1);

    public long currentTimeMillis();

    public void sleep(Duration var1);

    public void registerDelayedCallback(Duration var1, Runnable var2);

    public IWorkflowService getWorkflowService();

    public String getDomain();

    public String getDiagnostics();

    public void close();

    public WorkerFactory getWorkerFactory();

    public void start();

    public boolean isStarted();

    public boolean isShutdown();

    public boolean isTerminated();

    public void shutdown();

    public void shutdownNow();

    public void awaitTermination(long var1, TimeUnit var3);
}

