/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.serviceclient;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.uber.cadence.BadRequestError;
import com.uber.cadence.ClientVersionNotSupportedError;
import com.uber.cadence.ClusterInfo;
import com.uber.cadence.CountWorkflowExecutionsRequest;
import com.uber.cadence.CountWorkflowExecutionsResponse;
import com.uber.cadence.DeprecateDomainRequest;
import com.uber.cadence.DescribeDomainRequest;
import com.uber.cadence.DescribeDomainResponse;
import com.uber.cadence.DescribeTaskListRequest;
import com.uber.cadence.DescribeTaskListResponse;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.DomainAlreadyExistsError;
import com.uber.cadence.DomainNotActiveError;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.GetSearchAttributesResponse;
import com.uber.cadence.GetTaskListsByDomainRequest;
import com.uber.cadence.GetTaskListsByDomainResponse;
import com.uber.cadence.GetWorkflowExecutionHistoryRequest;
import com.uber.cadence.GetWorkflowExecutionHistoryResponse;
import com.uber.cadence.History;
import com.uber.cadence.InternalServiceError;
import com.uber.cadence.LimitExceededError;
import com.uber.cadence.ListArchivedWorkflowExecutionsRequest;
import com.uber.cadence.ListArchivedWorkflowExecutionsResponse;
import com.uber.cadence.ListClosedWorkflowExecutionsRequest;
import com.uber.cadence.ListClosedWorkflowExecutionsResponse;
import com.uber.cadence.ListDomainsRequest;
import com.uber.cadence.ListDomainsResponse;
import com.uber.cadence.ListOpenWorkflowExecutionsRequest;
import com.uber.cadence.ListOpenWorkflowExecutionsResponse;
import com.uber.cadence.ListTaskListPartitionsRequest;
import com.uber.cadence.ListTaskListPartitionsResponse;
import com.uber.cadence.ListWorkflowExecutionsRequest;
import com.uber.cadence.ListWorkflowExecutionsResponse;
import com.uber.cadence.PollForActivityTaskRequest;
import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.PollForDecisionTaskRequest;
import com.uber.cadence.PollForDecisionTaskResponse;
import com.uber.cadence.QueryFailedError;
import com.uber.cadence.QueryWorkflowRequest;
import com.uber.cadence.QueryWorkflowResponse;
import com.uber.cadence.RecordActivityTaskHeartbeatByIDRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatRequest;
import com.uber.cadence.RecordActivityTaskHeartbeatResponse;
import com.uber.cadence.RefreshWorkflowTasksRequest;
import com.uber.cadence.RegisterDomainRequest;
import com.uber.cadence.RequestCancelWorkflowExecutionRequest;
import com.uber.cadence.ResetStickyTaskListRequest;
import com.uber.cadence.ResetStickyTaskListResponse;
import com.uber.cadence.ResetWorkflowExecutionRequest;
import com.uber.cadence.ResetWorkflowExecutionResponse;
import com.uber.cadence.RespondActivityTaskCanceledByIDRequest;
import com.uber.cadence.RespondActivityTaskCanceledRequest;
import com.uber.cadence.RespondActivityTaskCompletedByIDRequest;
import com.uber.cadence.RespondActivityTaskCompletedRequest;
import com.uber.cadence.RespondActivityTaskFailedByIDRequest;
import com.uber.cadence.RespondActivityTaskFailedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedRequest;
import com.uber.cadence.RespondDecisionTaskCompletedResponse;
import com.uber.cadence.RespondDecisionTaskFailedRequest;
import com.uber.cadence.RespondQueryTaskCompletedRequest;
import com.uber.cadence.ServiceBusyError;
import com.uber.cadence.SignalWithStartWorkflowExecutionRequest;
import com.uber.cadence.SignalWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionRequest;
import com.uber.cadence.StartWorkflowExecutionResponse;
import com.uber.cadence.TerminateWorkflowExecutionRequest;
import com.uber.cadence.UpdateDomainRequest;
import com.uber.cadence.UpdateDomainResponse;
import com.uber.cadence.WorkflowExecutionAlreadyCompletedError;
import com.uber.cadence.WorkflowExecutionAlreadyStartedError;
import com.uber.cadence.WorkflowService;
import com.uber.cadence.internal.Version;
import com.uber.cadence.internal.common.CheckedExceptionWrapper;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.serviceclient.ClientOptions;
import com.uber.cadence.serviceclient.IWorkflowService;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.errors.ErrorType;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import com.uber.tchannel.messages.generated.Meta;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowServiceTChannel
implements IWorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceTChannel.class);
    private static final String INTERFACE_NAME = "WorkflowService";
    private final ClientOptions options;
    private final Map<String, String> thriftHeaders;
    private final TChannel tChannel;
    private SubChannel subChannel;

    public WorkflowServiceTChannel(ClientOptions options) {
        InetAddress address;
        this.options = options;
        this.thriftHeaders = WorkflowServiceTChannel.getThriftHeaders(options);
        this.tChannel = new TChannel.Builder(options.getClientAppName()).build();
        try {
            address = InetAddress.getByName(options.getHost());
        }
        catch (UnknownHostException e) {
            this.tChannel.shutdown();
            throw new RuntimeException("Unable to get name of host " + options.getHost(), e);
        }
        ArrayList<InetSocketAddress> peers = new ArrayList<InetSocketAddress>();
        peers.add(new InetSocketAddress(address, options.getPort()));
        this.subChannel = this.tChannel.makeSubChannel(options.getServiceName()).setPeers(peers);
        log.info("Initialized TChannel for service " + this.subChannel.getServiceName() + ", LibraryVersion: " + Version.LIBRARY_VERSION + ", FeatureVersion: " + "1.5.0");
    }

    public void resetSubchannelPeers() throws UnknownHostException {
        InetAddress address = InetAddress.getByName(this.options.getHost());
        ArrayList<InetSocketAddress> peers = new ArrayList<InetSocketAddress>();
        peers.add(new InetSocketAddress(address, this.options.getPort()));
        this.subChannel.setPeers(peers);
    }

    public WorkflowServiceTChannel(SubChannel subChannel, ClientOptions options) {
        this.options = options;
        this.thriftHeaders = WorkflowServiceTChannel.getThriftHeaders(options);
        this.tChannel = null;
        this.subChannel = subChannel;
    }

    private static Map<String, String> getThriftHeaders(ClientOptions options) {
        String envHostname;
        String envUserName = System.getProperty("user.name");
        try {
            envHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            envHostname = "localhost";
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"user-name", (Object)envUserName).put((Object)"host-name", (Object)envHostname).put((Object)"cadence-client-library-version", (Object)Version.LIBRARY_VERSION).put((Object)"cadence-client-feature-version", (Object)"1.5.0").put((Object)"cadence-client-name", (Object)"uber-java");
        if (options.getHeaders() != null) {
            for (Map.Entry<String, String> entry : options.getHeaders().entrySet()) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        if (options.getFeatureFlags() != null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String serialized = gson.toJson((Object)options.getFeatureFlags());
            builder.put((Object)"cadence-client-feature-flags", (Object)serialized);
        }
        return builder.build();
    }

    private static String getEndpoint(String service, String method) {
        return String.format("%s::%s", service, method);
    }

    private <T> ThriftRequest<T> buildThriftRequest(String apiName, T body) {
        return this.buildThriftRequest(apiName, body, null);
    }

    @Override
    public CompletableFuture<Boolean> isHealthy() {
        ThriftRequest req = new ThriftRequest.Builder(this.options.getServiceName(), "Meta::health").setBody((Object)new Meta.health_args()).build();
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        try {
            TFuture future = this.subChannel.send(req);
            future.addCallback(response -> {
                req.releaseQuietly();
                if (response.isError()) {
                    try {
                        this.resetSubchannelPeers();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result.completeExceptionally(new TException("Rpc error:" + response.getError()));
                } else {
                    result.complete(((Meta.health_result)response.getBody(Meta.health_result.class)).getSuccess().isOk());
                }
                try {
                    response.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (TChannelError e) {
            req.releaseQuietly();
            try {
                this.resetSubchannelPeers();
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.complete(Boolean.FALSE);
        }
        return result;
    }

    protected <T> ThriftRequest<T> buildThriftRequest(String apiName, T body, Long rpcTimeoutOverride) {
        String endpoint = WorkflowServiceTChannel.getEndpoint(INTERFACE_NAME, apiName);
        ThriftRequest.Builder builder = new ThriftRequest.Builder(this.options.getServiceName(), endpoint);
        HashMap<String, String> headers = new HashMap<String, String>(this.thriftHeaders);
        TextMapPropagator textMapPropagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        String tracingHeadersPrefix = "$tracing$";
        TextMapSetter setter = (carrier, key, value) -> {
            if (carrier != null) {
                carrier.put(tracingHeadersPrefix + key, value);
            }
        };
        textMapPropagator.inject(Context.current(), headers, setter);
        if (this.options.getAuthProvider() != null) {
            headers.put("cadence-authorization", new String(this.options.getAuthProvider().getAuthToken(), StandardCharsets.UTF_8));
        }
        builder.setHeaders(headers);
        if (rpcTimeoutOverride != null) {
            builder.setTimeout(rpcTimeoutOverride.longValue());
        } else {
            builder.setTimeout(this.options.getRpcTimeoutMillis());
        }
        for (Map.Entry<String, String> header : this.options.getTransportHeaders().entrySet()) {
            builder.setTransportHeader(header.getKey(), header.getValue());
        }
        builder.setBody(body);
        return builder.build();
    }

    private <T> ThriftResponse<T> doRemoteCall(ThriftRequest<?> request) throws TException {
        ThriftResponse response = null;
        try {
            TFuture future = this.subChannel.send(request);
            response = (ThriftResponse)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TException((Throwable)e);
        }
        catch (TChannelError e) {
            throw new TException("Rpc error", (Throwable)e);
        }
        this.throwOnRpcError(response);
        return response;
    }

    private <T> CompletableFuture<ThriftResponse<T>> doRemoteCallAsync(ThriftRequest<?> request) {
        CompletableFuture result = new CompletableFuture();
        TFuture future = null;
        try {
            future = this.subChannel.send(request);
        }
        catch (TChannelError tChannelError) {
            result.completeExceptionally(new TException((Throwable)tChannelError));
        }
        future.addCallback(response -> {
            if (response.isError()) {
                result.completeExceptionally(new TException("Rpc error:" + response.getError()));
            } else {
                result.complete((ThriftResponse)response);
            }
        });
        return result;
    }

    private void throwOnRpcError(ThriftResponse<?> response) throws TException {
        if (response.isError()) {
            if (response.getError().getErrorType() == ErrorType.Timeout) {
                throw new TTransportException(3, response.getError().getMessage());
            }
            throw new TException("Rpc error:" + response.getError());
        }
    }

    @Override
    public void close() {
        if (this.tChannel != null) {
            this.tChannel.shutdown();
        }
    }

    private <T> T measureRemoteCall(String scopeName, RemoteCall<T> call) throws TException {
        return this.measureRemoteCallWithTags(scopeName, call, null);
    }

    private <T> T measureRemoteCallWithTags(String scopeName, RemoteCall<T> call, Map<String, String> tags) throws TException {
        Scope scope = this.options.getMetricsScope().subScope(scopeName);
        if (tags != null) {
            scope = scope.tagged(tags);
        }
        scope.counter("cadence-request").inc(1L);
        Stopwatch sw = scope.timer("cadence-latency").start();
        try {
            T resp = call.apply();
            sw.stop();
            return resp;
        }
        catch (BadRequestError | DomainAlreadyExistsError | EntityNotExistsError | QueryFailedError | WorkflowExecutionAlreadyCompletedError | WorkflowExecutionAlreadyStartedError e) {
            sw.stop();
            scope.counter("cadence-invalid-request").inc(1L);
            throw e;
        }
        catch (TException e) {
            sw.stop();
            scope.counter("cadence-error").inc(1L);
            throw e;
        }
    }

    private void measureRemoteProc(String scopeName, RemoteProc proc) throws TException {
        this.measureRemoteCall(scopeName, () -> {
            proc.apply();
            return null;
        });
    }

    @Override
    public void RegisterDomain(RegisterDomainRequest request) throws TException {
        this.measureRemoteProc("cadence-RegisterDomain", () -> this.registerDomain(request));
    }

    private void registerDomain(RegisterDomainRequest registerRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RegisterDomain_args> request = this.buildThriftRequest("RegisterDomain", new WorkflowService.RegisterDomain_args(registerRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RegisterDomain_result result = (WorkflowService.RegisterDomain_result)response.getBody(WorkflowService.RegisterDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetDomainExistsError()) {
                throw result.getDomainExistsError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("RegisterDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public DescribeDomainResponse DescribeDomain(DescribeDomainRequest describeRequest) throws TException {
        return this.measureRemoteCall("cadence-DescribeDomain", () -> this.describeDomain(describeRequest));
    }

    private DescribeDomainResponse describeDomain(DescribeDomainRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DescribeDomain_args> request = this.buildThriftRequest("DescribeDomain", new WorkflowService.DescribeDomain_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DescribeDomain_result result = (WorkflowService.DescribeDomain_result)response.getBody(WorkflowService.DescribeDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                DescribeDomainResponse describeDomainResponse = result.getSuccess();
                return describeDomainResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("DescribeDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListDomainsResponse ListDomains(ListDomainsRequest listRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, TException {
        return this.measureRemoteCall("cadence-ListDomains", () -> this.listDomains(listRequest));
    }

    private ListDomainsResponse listDomains(ListDomainsRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListDomains_args> request = this.buildThriftRequest("ListDomains", new WorkflowService.ListDomains_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListDomains_result result = (WorkflowService.ListDomains_result)response.getBody(WorkflowService.ListDomains_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListDomainsResponse listDomainsResponse = result.getSuccess();
                return listDomainsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("ListDomains failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public UpdateDomainResponse UpdateDomain(UpdateDomainRequest updateRequest) throws TException {
        return this.measureRemoteCall("cadence-UpdateDomain", () -> this.updateDomain(updateRequest));
    }

    private UpdateDomainResponse updateDomain(UpdateDomainRequest updateRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.UpdateDomain_args> request = this.buildThriftRequest("UpdateDomain", new WorkflowService.UpdateDomain_args(updateRequest));
            response = this.doRemoteCall(request);
            WorkflowService.UpdateDomain_result result = (WorkflowService.UpdateDomain_result)response.getBody(WorkflowService.UpdateDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                UpdateDomainResponse updateDomainResponse = result.getSuccess();
                return updateDomainResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            throw new TException("UpdateDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void DeprecateDomain(DeprecateDomainRequest deprecateRequest) throws TException {
        this.measureRemoteProc("cadence-DeprecateDomain", () -> this.deprecateDomain(deprecateRequest));
    }

    private void deprecateDomain(DeprecateDomainRequest deprecateRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DeprecateDomain_args> request = this.buildThriftRequest("DeprecateDomain", new WorkflowService.DeprecateDomain_args(deprecateRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DeprecateDomain_result result = (WorkflowService.DeprecateDomain_result)response.getBody(WorkflowService.DeprecateDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            throw new TException("DeprecateDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public GetTaskListsByDomainResponse GetTaskListsByDomain(GetTaskListsByDomainRequest getTaskListsByDomainRequest) throws TException {
        return this.measureRemoteCall("cadence-GetTaskListsByDomain", () -> this.getTaskListsByDomain(getTaskListsByDomainRequest));
    }

    private GetTaskListsByDomainResponse getTaskListsByDomain(GetTaskListsByDomainRequest getTaskListsByDomainRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.GetTaskListsByDomain_args> request = this.buildThriftRequest("GetTaskListsByDomain", new WorkflowService.GetTaskListsByDomain_args(getTaskListsByDomainRequest));
            response = this.doRemoteCall(request);
            WorkflowService.GetTaskListsByDomain_result result = (WorkflowService.GetTaskListsByDomain_result)response.getBody(WorkflowService.GetTaskListsByDomain_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                GetTaskListsByDomainResponse getTaskListsByDomainResponse = result.getSuccess();
                return getTaskListsByDomainResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("GetTaskListsByDomain failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public StartWorkflowExecutionResponse StartWorkflowExecution(StartWorkflowExecutionRequest request) throws TException {
        return this.measureRemoteCall("cadence-StartWorkflowExecution", () -> this.startWorkflowExecution(request));
    }

    private StartWorkflowExecutionResponse startWorkflowExecution(StartWorkflowExecutionRequest startRequest) throws TException {
        startRequest.setRequestId(UUID.randomUUID().toString());
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.StartWorkflowExecution_args> request = this.buildThriftRequest("StartWorkflowExecution", new WorkflowService.StartWorkflowExecution_args(startRequest));
            response = this.doRemoteCall(request);
            WorkflowService.StartWorkflowExecution_result result = (WorkflowService.StartWorkflowExecution_result)response.getBody(WorkflowService.StartWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                StartWorkflowExecutionResponse startWorkflowExecutionResponse = result.getSuccess();
                return startWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetSessionAlreadyExistError()) {
                throw result.getSessionAlreadyExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            throw new TException("StartWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public GetWorkflowExecutionHistoryResponse GetWorkflowExecutionHistoryWithTimeout(GetWorkflowExecutionHistoryRequest request, Long timeoutInMillis) throws TException {
        ImmutableMap tags = ImmutableMap.of((Object)"RequestType", (Object)(request.isWaitForNewEvent() ? "long-poll" : "normal"));
        return this.measureRemoteCallWithTags("cadence-GetWorkflowExecutionHistory", () -> this.getWorkflowExecutionHistory(request, timeoutInMillis), (Map<String, String>)tags);
    }

    @Override
    public GetWorkflowExecutionHistoryResponse GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest request) throws TException {
        ImmutableMap tags = ImmutableMap.of((Object)"RequestType", (Object)(request.isWaitForNewEvent() ? "long-poll" : "normal"));
        return this.measureRemoteCallWithTags("cadence-GetWorkflowExecutionHistory", () -> this.getWorkflowExecutionHistory(request, null), (Map<String, String>)tags);
    }

    private GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, Long timeoutInMillis) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.GetWorkflowExecutionHistory_args> request = this.buildGetWorkflowExecutionHistoryThriftRequest(getRequest, timeoutInMillis);
            response = this.doRemoteCall(request);
            WorkflowService.GetWorkflowExecutionHistory_result result = (WorkflowService.GetWorkflowExecutionHistory_result)response.getBody(WorkflowService.GetWorkflowExecutionHistory_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                GetWorkflowExecutionHistoryResponse res = result.getSuccess();
                if (res.getRawHistory() != null) {
                    History history = InternalUtils.DeserializeFromBlobDataToHistory(res.getRawHistory(), getRequest.getHistoryEventFilterType());
                    res.setHistory(history);
                }
                GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistoryResponse = res;
                return getWorkflowExecutionHistoryResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("GetWorkflowExecutionHistory failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    private ThriftRequest<WorkflowService.GetWorkflowExecutionHistory_args> buildGetWorkflowExecutionHistoryThriftRequest(GetWorkflowExecutionHistoryRequest getRequest, Long timeoutInMillis) {
        timeoutInMillis = getRequest.isWaitForNewEvent() ? this.validateAndUpdateTimeout(timeoutInMillis, this.options.getRpcLongPollTimeoutMillis()) : this.validateAndUpdateTimeout(timeoutInMillis, this.options.getRpcTimeoutMillis());
        return this.buildThriftRequest("GetWorkflowExecutionHistory", new WorkflowService.GetWorkflowExecutionHistory_args(getRequest), timeoutInMillis);
    }

    @Override
    public PollForDecisionTaskResponse PollForDecisionTask(PollForDecisionTaskRequest request) throws TException {
        return this.measureRemoteCall("cadence-PollForDecisionTask", () -> this.pollForDecisionTask(request));
    }

    private PollForDecisionTaskResponse pollForDecisionTask(PollForDecisionTaskRequest pollRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.PollForDecisionTask_args> request = this.buildThriftRequest("PollForDecisionTask", new WorkflowService.PollForDecisionTask_args(pollRequest), this.options.getRpcLongPollTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.PollForDecisionTask_result result = (WorkflowService.PollForDecisionTask_result)response.getBody(WorkflowService.PollForDecisionTask_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                PollForDecisionTaskResponse pollForDecisionTaskResponse = result.getSuccess();
                return pollForDecisionTaskResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("PollForDecisionTask failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public RespondDecisionTaskCompletedResponse RespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completedRequest) throws TException {
        return this.measureRemoteCall("cadence-RespondDecisionTaskCompleted", () -> this.respondDecisionTaskCompleted(completedRequest));
    }

    private RespondDecisionTaskCompletedResponse respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completedRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondDecisionTaskCompleted_args> request = this.buildThriftRequest("RespondDecisionTaskCompleted", new WorkflowService.RespondDecisionTaskCompleted_args(completedRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondDecisionTaskCompleted_result result = (WorkflowService.RespondDecisionTaskCompleted_result)response.getBody(WorkflowService.RespondDecisionTaskCompleted_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                RespondDecisionTaskCompletedResponse respondDecisionTaskCompletedResponse = result.getSuccess();
                return respondDecisionTaskCompletedResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondDecisionTaskCompleted failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondDecisionTaskFailed(RespondDecisionTaskFailedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondDecisionTaskFailed", () -> this.respondDecisionTaskFailed(request));
    }

    private void respondDecisionTaskFailed(RespondDecisionTaskFailedRequest failedRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondDecisionTaskFailed_args> request = this.buildThriftRequest("RespondDecisionTaskFailed", new WorkflowService.RespondDecisionTaskFailed_args(failedRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondDecisionTaskFailed_result result = (WorkflowService.RespondDecisionTaskFailed_result)response.getBody(WorkflowService.RespondDecisionTaskFailed_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondDecisionTaskFailed failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public PollForActivityTaskResponse PollForActivityTask(PollForActivityTaskRequest request) throws TException {
        return this.measureRemoteCall("cadence-PollForActivityTask", () -> this.pollForActivityTask(request));
    }

    private PollForActivityTaskResponse pollForActivityTask(PollForActivityTaskRequest pollRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.PollForActivityTask_args> request = this.buildThriftRequest("PollForActivityTask", new WorkflowService.PollForActivityTask_args(pollRequest), this.options.getRpcLongPollTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.PollForActivityTask_result result = (WorkflowService.PollForActivityTask_result)response.getBody(WorkflowService.PollForActivityTask_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                PollForActivityTaskResponse pollForActivityTaskResponse = result.getSuccess();
                return pollForActivityTaskResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("PollForActivityTask failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public RecordActivityTaskHeartbeatResponse RecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest request) throws TException {
        return this.measureRemoteCall("cadence-RecordActivityTaskHeartbeat", () -> this.recordActivityTaskHeartbeat(request));
    }

    private RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RecordActivityTaskHeartbeat_args> request = this.buildThriftRequest("RecordActivityTaskHeartbeat", new WorkflowService.RecordActivityTaskHeartbeat_args(heartbeatRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RecordActivityTaskHeartbeat_result result = (WorkflowService.RecordActivityTaskHeartbeat_result)response.getBody(WorkflowService.RecordActivityTaskHeartbeat_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatResponse = result.getSuccess();
                return recordActivityTaskHeartbeatResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RecordActivityTaskHeartbeat failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public RecordActivityTaskHeartbeatResponse RecordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, DomainNotActiveError, WorkflowExecutionAlreadyCompletedError, LimitExceededError, ServiceBusyError, TException {
        return this.measureRemoteCall("cadence-RecordActivityTaskHeartbeatByID", () -> this.recordActivityTaskHeartbeatByID(heartbeatRequest));
    }

    private RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RecordActivityTaskHeartbeatByID_args> request = this.buildThriftRequest("RecordActivityTaskHeartbeatByID", new WorkflowService.RecordActivityTaskHeartbeatByID_args(heartbeatRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RecordActivityTaskHeartbeatByID_result result = (WorkflowService.RecordActivityTaskHeartbeatByID_result)response.getBody(WorkflowService.RecordActivityTaskHeartbeatByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                RecordActivityTaskHeartbeatResponse recordActivityTaskHeartbeatResponse = result.getSuccess();
                return recordActivityTaskHeartbeatResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RecordActivityTaskHeartbeatByID failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCompleted(RespondActivityTaskCompletedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCompleted", () -> this.respondActivityTaskCompleted(request));
    }

    private void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCompleted_args> request = this.buildThriftRequest("RespondActivityTaskCompleted", new WorkflowService.RespondActivityTaskCompleted_args(completeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCompleted_result result = (WorkflowService.RespondActivityTaskCompleted_result)response.getBody(WorkflowService.RespondActivityTaskCompleted_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondActivityTaskCompleted failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCompletedByID", () -> this.respondActivityTaskCompletedByID(request));
    }

    private void respondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest completeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCompletedByID_args> request = this.buildThriftRequest("RespondActivityTaskCompletedByID", new WorkflowService.RespondActivityTaskCompletedByID_args(completeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCompletedByID_result result = (WorkflowService.RespondActivityTaskCompletedByID_result)response.getBody(WorkflowService.RespondActivityTaskCompletedByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondActivityTaskCompletedByID failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskFailed(RespondActivityTaskFailedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskFailed", () -> this.respondActivityTaskFailed(request));
    }

    private void respondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskFailed_args> request = this.buildThriftRequest("RespondActivityTaskFailed", new WorkflowService.RespondActivityTaskFailed_args(failRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskFailed_result result = (WorkflowService.RespondActivityTaskFailed_result)response.getBody(WorkflowService.RespondActivityTaskFailed_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondActivityTaskFailed failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskFailedByID", () -> this.respondActivityTaskFailedByID(request));
    }

    private void respondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest failRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskFailedByID_args> request = this.buildThriftRequest("RespondActivityTaskFailedByID", new WorkflowService.RespondActivityTaskFailedByID_args(failRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskFailedByID_result result = (WorkflowService.RespondActivityTaskFailedByID_result)response.getBody(WorkflowService.RespondActivityTaskFailedByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondActivityTaskFailedByID failedByID with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCanceled(RespondActivityTaskCanceledRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCanceled", () -> this.respondActivityTaskCanceled(request));
    }

    private void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCanceled_args> request = this.buildThriftRequest("RespondActivityTaskCanceled", new WorkflowService.RespondActivityTaskCanceled_args(canceledRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCanceled_result result = (WorkflowService.RespondActivityTaskCanceled_result)response.getBody(WorkflowService.RespondActivityTaskCanceled_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondActivityTaskCanceled failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondActivityTaskCanceledByID", () -> this.respondActivityTaskCanceledByID(request));
    }

    private void respondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest canceledByIDRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondActivityTaskCanceledByID_args> request = this.buildThriftRequest("RespondActivityTaskCanceledByID", new WorkflowService.RespondActivityTaskCanceledByID_args(canceledByIDRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondActivityTaskCanceledByID_result result = (WorkflowService.RespondActivityTaskCanceledByID_result)response.getBody(WorkflowService.RespondActivityTaskCanceledByID_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondActivityTaskCanceledByID failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest request) throws TException {
        this.measureRemoteProc("cadence-RequestCancelWorkflowExecution", () -> this.requestCancelWorkflowExecution(request));
    }

    private void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest) throws TException {
        cancelRequest.setRequestId(UUID.randomUUID().toString());
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RequestCancelWorkflowExecution_args> request = this.buildThriftRequest("RequestCancelWorkflowExecution", new WorkflowService.RequestCancelWorkflowExecution_args(cancelRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RequestCancelWorkflowExecution_result result = (WorkflowService.RequestCancelWorkflowExecution_result)response.getBody(WorkflowService.RequestCancelWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetCancellationAlreadyRequestedError()) {
                throw result.getCancellationAlreadyRequestedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RequestCancelWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void SignalWorkflowExecution(SignalWorkflowExecutionRequest request) throws TException {
        this.measureRemoteProc("cadence-SignalWorkflowExecution", () -> this.signalWorkflowExecution(request));
    }

    private void signalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.SignalWorkflowExecution_args> request = this.buildThriftRequest("SignalWorkflowExecution", new WorkflowService.SignalWorkflowExecution_args(signalRequest));
            response = this.doRemoteCall(request);
            WorkflowService.SignalWorkflowExecution_result result = (WorkflowService.SignalWorkflowExecution_result)response.getBody(WorkflowService.SignalWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("SignalWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public StartWorkflowExecutionResponse SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest) throws TException {
        return this.measureRemoteCall("cadence-SignalWithStartWorkflowExecution", () -> this.signalWithStartWorkflowExecution(signalWithStartRequest));
    }

    @Override
    public ResetWorkflowExecutionResponse ResetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, DomainNotActiveError, LimitExceededError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-ResetWorkflowExecution", () -> this.resetWorkflowExecution(resetRequest));
    }

    private ResetWorkflowExecutionResponse resetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ResetWorkflowExecution_args> request = this.buildThriftRequest("ResetWorkflowExecution", new WorkflowService.ResetWorkflowExecution_args(resetRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ResetWorkflowExecution_result result = (WorkflowService.ResetWorkflowExecution_result)response.getBody(WorkflowService.ResetWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ResetWorkflowExecutionResponse resetWorkflowExecutionResponse = result.getSuccess();
                return resetWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ResetWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    private StartWorkflowExecutionResponse signalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest) throws TException {
        signalWithStartRequest.setRequestId(UUID.randomUUID().toString());
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.SignalWithStartWorkflowExecution_args> request = this.buildThriftRequest("SignalWithStartWorkflowExecution", new WorkflowService.SignalWithStartWorkflowExecution_args(signalWithStartRequest));
            response = this.doRemoteCall(request);
            WorkflowService.SignalWithStartWorkflowExecution_result result = (WorkflowService.SignalWithStartWorkflowExecution_result)response.getBody(WorkflowService.SignalWithStartWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                StartWorkflowExecutionResponse startWorkflowExecutionResponse = result.getSuccess();
                return startWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("SignalWithStartWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest request) throws TException {
        this.measureRemoteProc("cadence-TerminateWorkflowExecution", () -> this.terminateWorkflowExecution(request));
    }

    private void terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.TerminateWorkflowExecution_args> request = this.buildThriftRequest("TerminateWorkflowExecution", new WorkflowService.TerminateWorkflowExecution_args(terminateRequest));
            response = this.doRemoteCall(request);
            WorkflowService.TerminateWorkflowExecution_result result = (WorkflowService.TerminateWorkflowExecution_result)response.getBody(WorkflowService.TerminateWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("TerminateWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListOpenWorkflowExecutionsResponse ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest request) throws TException {
        return this.measureRemoteCall("cadence-ListOpenWorkflowExecutions", () -> this.listOpenWorkflowExecutions(request));
    }

    private ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListOpenWorkflowExecutions_args> request = this.buildThriftRequest("ListOpenWorkflowExecutions", new WorkflowService.ListOpenWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListOpenWorkflowExecutions_result result = (WorkflowService.ListOpenWorkflowExecutions_result)response.getBody(WorkflowService.ListOpenWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListOpenWorkflowExecutionsResponse listOpenWorkflowExecutionsResponse = result.getSuccess();
                return listOpenWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ListOpenWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListClosedWorkflowExecutionsResponse ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest request) throws TException {
        return this.measureRemoteCall("cadence-ListClosedWorkflowExecutions", () -> this.listClosedWorkflowExecutions(request));
    }

    private ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListClosedWorkflowExecutions_args> request = this.buildThriftRequest("ListClosedWorkflowExecutions", new WorkflowService.ListClosedWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListClosedWorkflowExecutions_result result = (WorkflowService.ListClosedWorkflowExecutions_result)response.getBody(WorkflowService.ListClosedWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListClosedWorkflowExecutionsResponse listClosedWorkflowExecutionsResponse = result.getSuccess();
                return listClosedWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ListClosedWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListWorkflowExecutionsResponse ListWorkflowExecutions(ListWorkflowExecutionsRequest request) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-ListWorkflowExecutions", () -> this.listWorkflowExecutions(request));
    }

    private ListWorkflowExecutionsResponse listWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListWorkflowExecutions_args> request = this.buildThriftRequest("ListWorkflowExecutions", new WorkflowService.ListWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListWorkflowExecutions_result result = (WorkflowService.ListWorkflowExecutions_result)response.getBody(WorkflowService.ListWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListWorkflowExecutionsResponse listWorkflowExecutionsResponse = result.getSuccess();
                return listWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ListWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListArchivedWorkflowExecutionsResponse ListArchivedWorkflowExecutions(ListArchivedWorkflowExecutionsRequest listRequest) throws BadRequestError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-ListArchivedWorkflowExecutions", () -> this.listArchivedWorkflowExecutions(listRequest));
    }

    private ListArchivedWorkflowExecutionsResponse listArchivedWorkflowExecutions(ListArchivedWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListArchivedWorkflowExecutions_args> request = this.buildThriftRequest("ListArchivedWorkflowExecutions", new WorkflowService.ListArchivedWorkflowExecutions_args(listRequest), this.options.getRpcListArchivedWorkflowTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.ListArchivedWorkflowExecutions_result result = (WorkflowService.ListArchivedWorkflowExecutions_result)response.getBody(WorkflowService.ListArchivedWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListArchivedWorkflowExecutionsResponse listArchivedWorkflowExecutionsResponse = result.getSuccess();
                return listArchivedWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ListArchivedWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListWorkflowExecutionsResponse ScanWorkflowExecutions(ListWorkflowExecutionsRequest request) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-ScanWorkflowExecutions", () -> this.scanWorkflowExecutions(request));
    }

    private ListWorkflowExecutionsResponse scanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ScanWorkflowExecutions_args> request = this.buildThriftRequest("ScanWorkflowExecutions", new WorkflowService.ScanWorkflowExecutions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ScanWorkflowExecutions_result result = (WorkflowService.ScanWorkflowExecutions_result)response.getBody(WorkflowService.ScanWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListWorkflowExecutionsResponse listWorkflowExecutionsResponse = result.getSuccess();
                return listWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ScanWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public CountWorkflowExecutionsResponse CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-CountWorkflowExecutions", () -> this.countWorkflowExecutions(countRequest));
    }

    private CountWorkflowExecutionsResponse countWorkflowExecutions(CountWorkflowExecutionsRequest countRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.CountWorkflowExecutions_args> request = this.buildThriftRequest("CountWorkflowExecutions", new WorkflowService.CountWorkflowExecutions_args(countRequest));
            response = this.doRemoteCall(request);
            WorkflowService.CountWorkflowExecutions_result result = (WorkflowService.CountWorkflowExecutions_result)response.getBody(WorkflowService.CountWorkflowExecutions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                CountWorkflowExecutionsResponse countWorkflowExecutionsResponse = result.getSuccess();
                return countWorkflowExecutionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("CountWorkflowExecutions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public GetSearchAttributesResponse GetSearchAttributes() throws InternalServiceError, ServiceBusyError, ClientVersionNotSupportedError, TException {
        return this.measureRemoteCall("cadence-GetSearchAttributes", () -> this.getSearchAttributes());
    }

    private GetSearchAttributesResponse getSearchAttributes() throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.GetSearchAttributes_args> request = this.buildThriftRequest("GetSearchAttributes", new WorkflowService.GetSearchAttributes_args());
            response = this.doRemoteCall(request);
            WorkflowService.GetSearchAttributes_result result = (WorkflowService.GetSearchAttributes_result)response.getBody(WorkflowService.GetSearchAttributes_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                GetSearchAttributesResponse getSearchAttributesResponse = result.getSuccess();
                return getSearchAttributesResponse;
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("GetSearchAttributes failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void RespondQueryTaskCompleted(RespondQueryTaskCompletedRequest request) throws TException {
        this.measureRemoteProc("cadence-RespondQueryTaskCompleted", () -> this.respondQueryTaskCompleted(request));
    }

    private void respondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RespondQueryTaskCompleted_args> request = this.buildThriftRequest("RespondQueryTaskCompleted", new WorkflowService.RespondQueryTaskCompleted_args(completeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.RespondQueryTaskCompleted_result result = (WorkflowService.RespondQueryTaskCompleted_result)response.getBody(WorkflowService.RespondQueryTaskCompleted_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                return;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("RespondQueryTaskCompleted failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public QueryWorkflowResponse QueryWorkflow(QueryWorkflowRequest request) throws TException {
        return this.measureRemoteCall("cadence-QueryWorkflow", () -> this.queryWorkflow(request));
    }

    private QueryWorkflowResponse queryWorkflow(QueryWorkflowRequest queryRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.QueryWorkflow_args> request = this.buildThriftRequest("QueryWorkflow", new WorkflowService.QueryWorkflow_args(queryRequest), this.options.getRpcQueryTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.QueryWorkflow_result result = (WorkflowService.QueryWorkflow_result)response.getBody(WorkflowService.QueryWorkflow_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                QueryWorkflowResponse queryWorkflowResponse = result.getSuccess();
                return queryWorkflowResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetQueryFailedError()) {
                throw result.getQueryFailedError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("QueryWorkflow failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ResetStickyTaskListResponse ResetStickyTaskList(ResetStickyTaskListRequest resetRequest) throws BadRequestError, InternalServiceError, EntityNotExistsError, LimitExceededError, WorkflowExecutionAlreadyCompletedError, ServiceBusyError, DomainNotActiveError, TException {
        return this.measureRemoteCall("cadence-ResetStickyTaskList", () -> this.resetStickyTaskList(resetRequest));
    }

    private ResetStickyTaskListResponse resetStickyTaskList(ResetStickyTaskListRequest queryRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ResetStickyTaskList_args> request = this.buildThriftRequest("ResetStickyTaskList", new WorkflowService.ResetStickyTaskList_args(queryRequest), this.options.getRpcQueryTimeoutMillis());
            response = this.doRemoteCall(request);
            WorkflowService.ResetStickyTaskList_result result = (WorkflowService.ResetStickyTaskList_result)response.getBody(WorkflowService.ResetStickyTaskList_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ResetStickyTaskListResponse resetStickyTaskListResponse = result.getSuccess();
                return resetStickyTaskListResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                throw result.getWorkflowExecutionAlreadyCompletedError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("ResetStickyTaskList failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public DescribeWorkflowExecutionResponse DescribeWorkflowExecution(DescribeWorkflowExecutionRequest request) throws TException {
        return this.measureRemoteCall("cadence-DescribeWorkflowExecution", () -> this.describeWorkflowExecution(request));
    }

    private DescribeWorkflowExecutionResponse describeWorkflowExecution(DescribeWorkflowExecutionRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DescribeWorkflowExecution_args> request = this.buildThriftRequest("DescribeWorkflowExecution", new WorkflowService.DescribeWorkflowExecution_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DescribeWorkflowExecution_result result = (WorkflowService.DescribeWorkflowExecution_result)response.getBody(WorkflowService.DescribeWorkflowExecution_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                DescribeWorkflowExecutionResponse describeWorkflowExecutionResponse = result.getSuccess();
                return describeWorkflowExecutionResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("DescribeWorkflowExecution failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public DescribeTaskListResponse DescribeTaskList(DescribeTaskListRequest request) throws TException {
        return this.measureRemoteCall("cadence-DescribeTaskList", () -> this.describeTaskList(request));
    }

    private DescribeTaskListResponse describeTaskList(DescribeTaskListRequest describeRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.DescribeTaskList_args> request = this.buildThriftRequest("DescribeTaskList", new WorkflowService.DescribeTaskList_args(describeRequest));
            response = this.doRemoteCall(request);
            WorkflowService.DescribeTaskList_result result = (WorkflowService.DescribeTaskList_result)response.getBody(WorkflowService.DescribeTaskList_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                DescribeTaskListResponse describeTaskListResponse = result.getSuccess();
                return describeTaskListResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            if (result.isSetClientVersionNotSupportedError()) {
                throw result.getClientVersionNotSupportedError();
            }
            throw new TException("DescribeTaskList failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ClusterInfo GetClusterInfo() throws InternalServiceError, ServiceBusyError, TException {
        return this.measureRemoteCall("cadence-GetClusterInfo", () -> this.getClusterInfo());
    }

    private ClusterInfo getClusterInfo() throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.GetClusterInfo_args> request = this.buildThriftRequest("GetClusterInfo", new WorkflowService.GetClusterInfo_args());
            response = this.doRemoteCall(request);
            WorkflowService.GetClusterInfo_result result = (WorkflowService.GetClusterInfo_result)response.getBody(WorkflowService.GetClusterInfo_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ClusterInfo clusterInfo = result.getSuccess();
                return clusterInfo;
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            throw new TException("GetClusterInfo failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public ListTaskListPartitionsResponse ListTaskListPartitions(ListTaskListPartitionsRequest request) throws BadRequestError, EntityNotExistsError, LimitExceededError, ServiceBusyError, TException {
        return this.measureRemoteCall("cadence-ListTaskListPartitions", () -> this.listTaskListPartitions(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void RefreshWorkflowTasks(RefreshWorkflowTasksRequest refreshWorkflowTasks) throws BadRequestError, DomainNotActiveError, ServiceBusyError, EntityNotExistsError, TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.RefreshWorkflowTasks_args> request = this.buildThriftRequest("RefreshWorkflowTasks", new WorkflowService.RefreshWorkflowTasks_args(refreshWorkflowTasks));
            response = this.doRemoteCall(request);
            WorkflowService.RefreshWorkflowTasks_result result = (WorkflowService.RefreshWorkflowTasks_result)response.getBody(WorkflowService.RefreshWorkflowTasks_result.class);
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetDomainNotActiveError()) {
                throw result.getDomainNotActiveError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    private ListTaskListPartitionsResponse listTaskListPartitions(ListTaskListPartitionsRequest listRequest) throws TException {
        ThriftResponse response = null;
        try {
            ThriftRequest<WorkflowService.ListTaskListPartitions_args> request = this.buildThriftRequest("ListTaskListPartitions", new WorkflowService.ListTaskListPartitions_args(listRequest));
            response = this.doRemoteCall(request);
            WorkflowService.ListTaskListPartitions_result result = (WorkflowService.ListTaskListPartitions_result)response.getBody(WorkflowService.ListTaskListPartitions_result.class);
            if (response.getResponseCode() == ResponseCode.OK) {
                ListTaskListPartitionsResponse listTaskListPartitionsResponse = result.getSuccess();
                return listTaskListPartitionsResponse;
            }
            if (result.isSetBadRequestError()) {
                throw result.getBadRequestError();
            }
            if (result.isSetEntityNotExistError()) {
                throw result.getEntityNotExistError();
            }
            if (result.isSetServiceBusyError()) {
                throw result.getServiceBusyError();
            }
            if (result.isSetLimitExceededError()) {
                throw result.getLimitExceededError();
            }
            throw new TException("ListTaskListPartitions failed with unknown error:" + result);
        }
        finally {
            if (response != null) {
                response.release();
            }
        }
    }

    @Override
    public void StartWorkflowExecution(StartWorkflowExecutionRequest startRequest, AsyncMethodCallback resultHandler) {
        this.startWorkflowExecution(startRequest, resultHandler, null);
    }

    @Override
    public void StartWorkflowExecutionWithTimeout(StartWorkflowExecutionRequest startRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) {
        this.startWorkflowExecution(startRequest, resultHandler, timeoutInMillis);
    }

    private void startWorkflowExecution(StartWorkflowExecutionRequest startRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) {
        startRequest.setRequestId(UUID.randomUUID().toString());
        timeoutInMillis = this.validateAndUpdateTimeout(timeoutInMillis, this.options.getRpcTimeoutMillis());
        ThriftRequest<WorkflowService.StartWorkflowExecution_args> request = this.buildThriftRequest("StartWorkflowExecution", new WorkflowService.StartWorkflowExecution_args(startRequest), timeoutInMillis);
        CompletableFuture response = this.doRemoteCallAsync(request);
        ((CompletableFuture)response.whenComplete((r, e) -> {
            try {
                if (e != null) {
                    resultHandler.onError((Exception)CheckedExceptionWrapper.wrap(e));
                    return;
                }
                WorkflowService.StartWorkflowExecution_result result = (WorkflowService.StartWorkflowExecution_result)r.getBody(WorkflowService.StartWorkflowExecution_result.class);
                if (r.getResponseCode() == ResponseCode.OK) {
                    resultHandler.onComplete((Object)result.getSuccess());
                    return;
                }
                if (result.isSetBadRequestError()) {
                    resultHandler.onError((Exception)((Object)result.getBadRequestError()));
                    return;
                }
                if (result.isSetSessionAlreadyExistError()) {
                    resultHandler.onError((Exception)((Object)result.getSessionAlreadyExistError()));
                    return;
                }
                if (result.isSetServiceBusyError()) {
                    resultHandler.onError((Exception)((Object)result.getServiceBusyError()));
                    return;
                }
                if (result.isSetDomainNotActiveError()) {
                    resultHandler.onError((Exception)((Object)result.getDomainNotActiveError()));
                    return;
                }
                if (result.isSetLimitExceededError()) {
                    resultHandler.onError((Exception)((Object)result.getLimitExceededError()));
                    return;
                }
                if (result.isSetEntityNotExistError()) {
                    resultHandler.onError((Exception)((Object)result.getEntityNotExistError()));
                    return;
                }
                resultHandler.onError((Exception)((Object)new TException("StartWorkflowExecution failed with unknown error:" + result)));
            }
            finally {
                if (r != null) {
                    r.release();
                }
            }
        })).exceptionally(e -> {
            log.error("Unexpected error in StartWorkflowExecution", e);
            return null;
        });
    }

    private Long validateAndUpdateTimeout(Long timeoutInMillis, Long defaultTimeoutInMillis) {
        timeoutInMillis = timeoutInMillis == null || timeoutInMillis <= 0L || timeoutInMillis == Long.MAX_VALUE ? defaultTimeoutInMillis : Long.valueOf(Math.min(timeoutInMillis, defaultTimeoutInMillis));
        return timeoutInMillis;
    }

    @Override
    public void GetWorkflowExecutionHistoryWithTimeout(GetWorkflowExecutionHistoryRequest getRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) {
        this.getWorkflowExecutionHistory(getRequest, resultHandler, timeoutInMillis);
    }

    @Override
    public void GetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, AsyncMethodCallback resultHandler) {
        this.getWorkflowExecutionHistory(getRequest, resultHandler, null);
    }

    private void getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) {
        ThriftRequest<WorkflowService.GetWorkflowExecutionHistory_args> request = this.buildGetWorkflowExecutionHistoryThriftRequest(getRequest, timeoutInMillis);
        CompletableFuture response = this.doRemoteCallAsync(request);
        ((CompletableFuture)response.whenComplete((r, e) -> {
            try {
                if (e != null) {
                    resultHandler.onError((Exception)CheckedExceptionWrapper.wrap(e));
                    return;
                }
                WorkflowService.GetWorkflowExecutionHistory_result result = (WorkflowService.GetWorkflowExecutionHistory_result)r.getBody(WorkflowService.GetWorkflowExecutionHistory_result.class);
                if (r.getResponseCode() == ResponseCode.OK) {
                    GetWorkflowExecutionHistoryResponse res = result.getSuccess();
                    if (res.getRawHistory() != null) {
                        History history = InternalUtils.DeserializeFromBlobDataToHistory(res.getRawHistory(), getRequest.getHistoryEventFilterType());
                        res.setHistory(history);
                    }
                    resultHandler.onComplete((Object)res);
                    return;
                }
                if (result.isSetBadRequestError()) {
                    resultHandler.onError((Exception)((Object)result.getBadRequestError()));
                    return;
                }
                if (result.isSetEntityNotExistError()) {
                    resultHandler.onError((Exception)((Object)result.getEntityNotExistError()));
                    return;
                }
                if (result.isSetServiceBusyError()) {
                    resultHandler.onError((Exception)((Object)result.getServiceBusyError()));
                    return;
                }
                resultHandler.onError((Exception)((Object)new TException("GetWorkflowExecutionHistory failed with unknown error:" + result)));
            }
            catch (TException tException) {
                resultHandler.onError((Exception)((Object)tException));
            }
            finally {
                if (r != null) {
                    r.release();
                }
            }
        })).exceptionally(e -> {
            log.error("Unexpected error in GetWorkflowExecutionHistory", e);
            return null;
        });
    }

    @Override
    public void PollForDecisionTask(PollForDecisionTaskRequest pollRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondDecisionTaskFailed(RespondDecisionTaskFailedRequest failedRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void PollForActivityTask(PollForActivityTaskRequest pollRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RecordActivityTaskHeartbeatByID(RecordActivityTaskHeartbeatByIDRequest heartbeatRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCompletedByID(RespondActivityTaskCompletedByIDRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskFailedByID(RespondActivityTaskFailedByIDRequest failRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondActivityTaskCanceledByID(RespondActivityTaskCanceledByIDRequest canceledRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void SignalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, AsyncMethodCallback resultHandler) {
        this.signalWorkflowExecution(signalRequest, resultHandler, null);
    }

    @Override
    public void SignalWorkflowExecutionWithTimeout(SignalWorkflowExecutionRequest signalRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) {
        this.signalWorkflowExecution(signalRequest, resultHandler, timeoutInMillis);
    }

    private void signalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, AsyncMethodCallback resultHandler, Long timeoutInMillis) {
        timeoutInMillis = this.validateAndUpdateTimeout(timeoutInMillis, this.options.getRpcTimeoutMillis());
        ThriftRequest<WorkflowService.SignalWorkflowExecution_args> request = this.buildThriftRequest("SignalWorkflowExecution", new WorkflowService.SignalWorkflowExecution_args(signalRequest), timeoutInMillis);
        CompletableFuture response = this.doRemoteCallAsync(request);
        ((CompletableFuture)response.whenComplete((r, e) -> {
            try {
                if (e != null) {
                    resultHandler.onError((Exception)CheckedExceptionWrapper.wrap(e));
                    return;
                }
                WorkflowService.SignalWorkflowExecution_result result = (WorkflowService.SignalWorkflowExecution_result)r.getBody(WorkflowService.SignalWorkflowExecution_result.class);
                if (r.getResponseCode() == ResponseCode.OK) {
                    resultHandler.onComplete(null);
                    return;
                }
                if (result.isSetBadRequestError()) {
                    resultHandler.onError((Exception)((Object)result.getBadRequestError()));
                    return;
                }
                if (result.isSetEntityNotExistError()) {
                    resultHandler.onError((Exception)((Object)result.getEntityNotExistError()));
                    return;
                }
                if (result.isSetWorkflowExecutionAlreadyCompletedError()) {
                    resultHandler.onError((Exception)((Object)result.getWorkflowExecutionAlreadyCompletedError()));
                    return;
                }
                if (result.isSetServiceBusyError()) {
                    resultHandler.onError((Exception)((Object)result.getServiceBusyError()));
                    return;
                }
                if (result.isSetDomainNotActiveError()) {
                    resultHandler.onError((Exception)((Object)result.getDomainNotActiveError()));
                    return;
                }
                if (result.isSetLimitExceededError()) {
                    resultHandler.onError((Exception)((Object)result.getLimitExceededError()));
                    return;
                }
                if (result.isSetClientVersionNotSupportedError()) {
                    resultHandler.onError((Exception)((Object)result.getClientVersionNotSupportedError()));
                    return;
                }
                resultHandler.onError((Exception)((Object)new TException("SignalWorkflowExecution failed with unknown error:" + result)));
            }
            finally {
                if (r != null) {
                    r.release();
                }
            }
        })).exceptionally(e -> {
            log.error("Unexpected error in SignalWorkflowExecution", e);
            return null;
        });
    }

    @Override
    public void SignalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest signalWithStartRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ResetWorkflowExecution(ResetWorkflowExecutionRequest resetRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void TerminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListWorkflowExecutions(ListWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListArchivedWorkflowExecutions(ListArchivedWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ScanWorkflowExecutions(ListWorkflowExecutionsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void CountWorkflowExecutions(CountWorkflowExecutionsRequest countRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void GetSearchAttributes(AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void RespondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ResetStickyTaskList(ResetStickyTaskListRequest resetRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void QueryWorkflow(QueryWorkflowRequest queryRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DescribeWorkflowExecution(DescribeWorkflowExecutionRequest describeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DescribeTaskList(DescribeTaskListRequest request, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void GetClusterInfo(AsyncMethodCallback resultHandler) throws TException {
    }

    @Override
    public void ListTaskListPartitions(ListTaskListPartitionsRequest request, AsyncMethodCallback resultHandler) throws TException {
    }

    @Override
    public void RefreshWorkflowTasks(RefreshWorkflowTasksRequest request, AsyncMethodCallback resultHandler) throws TException {
    }

    @Override
    public void RegisterDomain(RegisterDomainRequest registerRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DescribeDomain(DescribeDomainRequest describeRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void ListDomains(ListDomainsRequest listRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void UpdateDomain(UpdateDomainRequest updateRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void DeprecateDomain(DeprecateDomainRequest deprecateRequest, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void GetTaskListsByDomain(GetTaskListsByDomainRequest request, AsyncMethodCallback resultHandler) throws TException {
        throw new UnsupportedOperationException("not implemented");
    }

    static interface RemoteProc {
        public void apply() throws TException;
    }

    static interface RemoteCall<T> {
        public T apply() throws TException;
    }
}

