/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker.autoscaler;

public class Recommender {
    private final float targetPollerUtilRate;
    private final int upperValue;
    private final int lowerValue;

    public Recommender(float targetPollerUtilRate, int upperValue, int lowerValue) {
        this.targetPollerUtilRate = targetPollerUtilRate;
        this.upperValue = upperValue;
        this.lowerValue = lowerValue;
    }

    public int recommend(int currentPollers, float pollerUtilizationRate) {
        if (pollerUtilizationRate == 1.0f) {
            return this.upperValue;
        }
        float r = (float)currentPollers * pollerUtilizationRate / this.targetPollerUtilRate;
        return Math.round(Math.min((float)this.upperValue, Math.max((float)this.lowerValue, r)));
    }

    public int getUpperValue() {
        return this.upperValue;
    }

    public int getLowerValue() {
        return this.lowerValue;
    }
}

