/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker.autoscaler;

import com.uber.cadence.internal.worker.autoscaler.AutoScaler;
import com.uber.cadence.internal.worker.autoscaler.PollerUsage;
import com.uber.cadence.internal.worker.autoscaler.PollerUsageEstimator;
import com.uber.cadence.internal.worker.autoscaler.Recommender;
import com.uber.cadence.internal.worker.autoscaler.ResizableSemaphore;
import java.time.Duration;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollerAutoScaler
implements AutoScaler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollerAutoScaler.class);
    private final Duration coolDownTime;
    private final PollerUsageEstimator pollerUsageEstimator;
    private final Recommender recommender;
    private final ResizableSemaphore semaphore;
    private int semaphoreSize;
    private boolean shuttingDown;

    public PollerAutoScaler(Duration coolDownTime, PollerUsageEstimator pollerUsageEstimator, Recommender recommender) {
        this.coolDownTime = coolDownTime;
        this.pollerUsageEstimator = pollerUsageEstimator;
        this.recommender = recommender;
        this.semaphore = new ResizableSemaphore(recommender.getUpperValue());
        this.semaphoreSize = recommender.getUpperValue();
    }

    @Override
    public void start() {
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                while (!PollerAutoScaler.this.shuttingDown) {
                    try {
                        Thread.sleep(PollerAutoScaler.this.coolDownTime.toMillis());
                        if (PollerAutoScaler.this.shuttingDown) continue;
                        PollerAutoScaler.this.resizePollers();
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("interrupted wait for next poller scaling");
                    }
                }
            }
        });
    }

    @Override
    public void stop() {
        LOGGER.info("shutting down poller autoscaler");
        this.shuttingDown = true;
    }

    protected void resizePollers() {
        PollerUsage pollerUsage = this.pollerUsageEstimator.estimate();
        int pollerCount = this.recommender.recommend(this.semaphoreSize, pollerUsage.getPollerUtilizationRate());
        int diff = this.semaphoreSize - pollerCount;
        if (diff < 0) {
            this.semaphore.release(diff * -1);
        } else {
            this.semaphore.decreasePermits(diff);
        }
        LOGGER.info(String.format("resized pollers to: %d", pollerCount));
        this.semaphoreSize = pollerCount;
    }

    @Override
    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    @Override
    public void release() {
        this.semaphore.release();
    }

    @Override
    public void increaseNoopPollCount() {
        this.pollerUsageEstimator.increaseNoopTaskCount();
    }

    @Override
    public void increaseActionablePollCount() {
        this.pollerUsageEstimator.increaseActionableTaskCount();
    }

    protected int getSemaphoreSize() {
        return this.semaphoreSize;
    }
}

