/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker.autoscaler;

import com.uber.cadence.internal.worker.PollerAutoScalerOptions;
import com.uber.cadence.internal.worker.PollerOptions;
import com.uber.cadence.internal.worker.autoscaler.AutoScaler;
import com.uber.cadence.internal.worker.autoscaler.NoopAutoScaler;
import com.uber.cadence.internal.worker.autoscaler.PollerAutoScaler;
import com.uber.cadence.internal.worker.autoscaler.PollerUsageEstimator;
import com.uber.cadence.internal.worker.autoscaler.Recommender;

public class AutoScalerFactory {
    private static final AutoScalerFactory INSTANCE = new AutoScalerFactory();

    private AutoScalerFactory() {
    }

    public AutoScaler createAutoScaler(PollerOptions pollerOptions) {
        if (pollerOptions == null || pollerOptions.getPollerAutoScalerOptions() == null) {
            return new NoopAutoScaler();
        }
        PollerAutoScalerOptions autoScalerOptions = pollerOptions.getPollerAutoScalerOptions();
        return new PollerAutoScaler(autoScalerOptions.getPollerScalingInterval(), new PollerUsageEstimator(), new Recommender(autoScalerOptions.getTargetPollerUtilisation(), pollerOptions.getPollThreadCount(), autoScalerOptions.getMinConcurrentPollers()));
    }

    public static AutoScalerFactory getInstance() {
        return INSTANCE;
    }
}

