/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.worker.WorkerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WorkerShutDownHandler {
    private static final List<WorkerFactory> workerFactories = new ArrayList<WorkerFactory>();
    private static Thread registeredHandler;

    public static void registerHandler() {
        if (registeredHandler != null) {
            return;
        }
        registeredHandler = new Thread("SHUTDOWN_WORKERS"){

            @Override
            public void run() {
                for (WorkerFactory workerFactory : workerFactories) {
                    workerFactory.suspendPolling();
                }
                for (WorkerFactory workerFactory : workerFactories) {
                    workerFactory.shutdownNow();
                }
                long remainingTimeout = 10000L;
                for (WorkerFactory workerFactory : workerFactories) {
                    long timeoutMillis = remainingTimeout;
                    remainingTimeout = InternalUtils.awaitTermination(timeoutMillis, () -> workerFactory.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS));
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(registeredHandler);
    }

    public static synchronized void registerWorkerFactory(WorkerFactory workerFactory) {
        if (workerFactory != null) {
            workerFactories.add(workerFactory);
        }
    }

    protected static void execute() {
        registeredHandler.run();
    }
}

