/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.worker;

import com.uber.cadence.PollForActivityTaskResponse;
import com.uber.cadence.internal.worker.ActivityPollTaskBase;
import com.uber.cadence.internal.worker.LocallyDispatchedActivityWorker;
import com.uber.cadence.internal.worker.SingleWorkerOptions;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Function;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocallyDispatchedActivityPollTask
extends ActivityPollTaskBase
implements Function<LocallyDispatchedActivityWorker.Task, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(LocallyDispatchedActivityPollTask.class);
    private final SynchronousQueue<LocallyDispatchedActivityWorker.Task> pendingTasks = new SynchronousQueue();

    public LocallyDispatchedActivityPollTask(SingleWorkerOptions options) {
        super(options);
    }

    @Override
    protected PollForActivityTaskResponse pollTask() throws TException {
        LocallyDispatchedActivityWorker.Task task;
        try {
            task = this.pendingTasks.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("locally dispatch activity poll task interrupted", e);
        }
        try {
            if (!task.await()) {
                this.options.getMetricsScope().counter("cadence-locally-dispatched-activity-poll-no-task").inc(1L);
                return null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("locally dispatch activity await task interrupted", e);
        }
        this.options.getMetricsScope().counter("cadence-activity-poll-total").inc(1L);
        this.options.getMetricsScope().counter("cadence-locally-dispatched-activity-poll-succeed").inc(1L);
        PollForActivityTaskResponse result = new PollForActivityTaskResponse();
        result.activityId = task.activityId;
        result.activityType = task.activityType;
        result.header = task.header;
        result.input = task.input;
        result.workflowExecution = task.workflowExecution;
        result.scheduledTimestampOfThisAttempt = task.scheduledTimestampOfThisAttempt;
        result.scheduledTimestamp = task.scheduledTimestamp;
        result.scheduleToCloseTimeoutSeconds = task.scheduleToCloseTimeoutSeconds;
        result.startedTimestamp = task.startedTimestamp;
        result.startToCloseTimeoutSeconds = task.startToCloseTimeoutSeconds;
        result.heartbeatTimeoutSeconds = task.heartbeatTimeoutSeconds;
        result.taskToken = task.taskToken;
        result.workflowType = task.workflowType;
        result.workflowDomain = task.workflowDomain;
        result.attempt = 0;
        return result;
    }

    @Override
    public Boolean apply(LocallyDispatchedActivityWorker.Task task) {
        return this.pendingTasks.offer(task);
    }
}

