/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.base.Defaults;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.client.DuplicateWorkflowException;
import com.uber.cadence.client.WorkflowClientInterceptor;
import com.uber.cadence.client.WorkflowClientOptions;
import com.uber.cadence.client.WorkflowOptions;
import com.uber.cadence.client.WorkflowStub;
import com.uber.cadence.common.CronSchedule;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.internal.common.InternalUtils;
import com.uber.cadence.internal.external.GenericWorkflowClientExternal;
import com.uber.cadence.internal.sync.SignalWithStartBatchRequest;
import com.uber.cadence.internal.sync.WorkflowStubImpl;
import com.uber.cadence.workflow.QueryMethod;
import com.uber.cadence.workflow.SignalMethod;
import com.uber.cadence.workflow.WorkflowMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;

class WorkflowInvocationHandler
implements InvocationHandler,
Supplier<WorkflowStub> {
    private static final ThreadLocal<SpecificInvocationHandler> invocationContext = new ThreadLocal();
    private final WorkflowStub untyped;

    @Override
    public WorkflowStub get() {
        return this.untyped;
    }

    static void initAsyncInvocation(InvocationType type) {
        WorkflowInvocationHandler.initAsyncInvocation(type, null);
    }

    static <T> void initAsyncInvocation(InvocationType type, T value) {
        if (invocationContext.get() != null) {
            throw new IllegalStateException("already in start invocation");
        }
        if (type == InvocationType.START) {
            invocationContext.set(new StartWorkflowInvocationHandler());
        } else if (type == InvocationType.EXECUTE) {
            invocationContext.set(new ExecuteWorkflowInvocationHandler());
        } else if (type == InvocationType.SIGNAL_WITH_START) {
            SignalWithStartBatchRequest batch = (SignalWithStartBatchRequest)value;
            invocationContext.set(new SignalWithStartWorkflowInvocationHandler(batch));
        } else {
            throw new IllegalArgumentException("Unexpected InvocationType: " + (Object)((Object)type));
        }
    }

    static <R> R getAsyncInvocationResult(Class<R> resultClass) {
        SpecificInvocationHandler invocation = invocationContext.get();
        if (invocation == null) {
            throw new IllegalStateException("initAsyncInvocation wasn't called");
        }
        return invocation.getResult(resultClass);
    }

    static void closeAsyncInvocation() {
        invocationContext.remove();
    }

    WorkflowInvocationHandler(Class<?> workflowInterface, WorkflowClientOptions clientOptions, GenericWorkflowClientExternal genericClient, WorkflowExecution execution, WorkflowClientInterceptor[] interceptors) {
        Method workflowMethod = InternalUtils.getWorkflowMethod(workflowInterface);
        WorkflowMethod annotation = workflowMethod.getAnnotation(WorkflowMethod.class);
        String workflowType = InternalUtils.getWorkflowType(workflowMethod, annotation);
        WorkflowStub stub = new WorkflowStubImpl(clientOptions, genericClient, Optional.of(workflowType), execution);
        for (WorkflowClientInterceptor i : interceptors) {
            stub = i.newUntypedWorkflowStub(execution, Optional.of(workflowType), stub);
        }
        this.untyped = stub;
    }

    WorkflowInvocationHandler(Class<?> workflowInterface, WorkflowClientOptions clientOptions, GenericWorkflowClientExternal genericClient, WorkflowOptions options, WorkflowClientInterceptor[] interceptors) {
        Method workflowMethod = InternalUtils.getWorkflowMethod(workflowInterface);
        MethodRetry methodRetry = workflowMethod.getAnnotation(MethodRetry.class);
        CronSchedule cronSchedule = workflowMethod.getAnnotation(CronSchedule.class);
        WorkflowMethod annotation = workflowMethod.getAnnotation(WorkflowMethod.class);
        String workflowType = InternalUtils.getWorkflowType(workflowMethod, annotation);
        WorkflowOptions mergedOptions = WorkflowOptions.merge(annotation, methodRetry, cronSchedule, options);
        WorkflowStub stub = new WorkflowStubImpl(clientOptions, genericClient, workflowType, mergedOptions);
        for (WorkflowClientInterceptor i : interceptors) {
            stub = i.newUntypedWorkflowStub(workflowType, mergedOptions, stub);
        }
        this.untyped = stub;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return "WorkflowInvocationHandler";
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error("unexpected", e);
        }
        if (!method.getDeclaringClass().isInterface()) {
            throw new IllegalArgumentException("Interface type is expected: " + method.getDeclaringClass());
        }
        SpecificInvocationHandler handler = invocationContext.get();
        if (handler == null) {
            handler = new SyncWorkflowInvocationHandler();
        }
        handler.invoke(this.untyped, method, args);
        if (handler.getInvocationType() == InvocationType.SYNC) {
            return handler.getResult(method.getReturnType());
        }
        return Defaults.defaultValue(method.getReturnType());
    }

    private static void startWorkflow(WorkflowStub untyped, Object[] args) {
        block3: {
            Optional<WorkflowOptions> options = untyped.getOptions();
            if (untyped.getExecution() == null || options.isPresent() && options.get().getWorkflowIdReusePolicy() == WorkflowIdReusePolicy.AllowDuplicate) {
                try {
                    untyped.start(args);
                }
                catch (DuplicateWorkflowException e) {
                    if (!options.isPresent() || options.get().getWorkflowIdReusePolicy() != WorkflowIdReusePolicy.AllowDuplicate) break block3;
                    throw e;
                }
            }
        }
    }

    static void checkAnnotations(Method method, WorkflowMethod workflowMethod, QueryMethod queryMethod, SignalMethod signalMethod) {
        int count = (workflowMethod == null ? 0 : 1) + (queryMethod == null ? 0 : 1) + (signalMethod == null ? 0 : 1);
        if (count > 1) {
            throw new IllegalArgumentException(method + " must contain at most one annotation from @WorkflowMethod, @QueryMethod or @SignalMethod");
        }
    }

    private static String nameFromMethodAndAnnotation(Method method, String name) {
        String signalName = name;
        if (signalName.isEmpty()) {
            signalName = InternalUtils.getSimpleName(method);
        }
        return signalName;
    }

    private static class SignalWithStartWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private final SignalWithStartBatchRequest batch;

        public SignalWithStartWorkflowInvocationHandler(SignalWithStartBatchRequest batch) {
            this.batch = batch;
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.SIGNAL_WITH_START;
        }

        @Override
        public void invoke(WorkflowStub untyped, Method method, Object[] args) throws Throwable {
            QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
            SignalMethod signalMethod = method.getAnnotation(SignalMethod.class);
            WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
            WorkflowInvocationHandler.checkAnnotations(method, workflowMethod, queryMethod, signalMethod);
            if (queryMethod != null) {
                throw new IllegalArgumentException("SignalWithStart batch doesn't accept methods annotated with @QueryMethod");
            }
            if (workflowMethod != null) {
                this.batch.start(untyped, args);
            } else if (signalMethod != null) {
                String signalName = WorkflowInvocationHandler.nameFromMethodAndAnnotation(method, signalMethod.name());
                this.batch.signal(untyped, signalName, args);
            } else {
                throw new IllegalArgumentException(method + " is not annotated with @WorkflowMethod or @SignalMethod");
            }
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            throw new IllegalStateException("No result is expected");
        }
    }

    private static class ExecuteWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private Object result;

        private ExecuteWorkflowInvocationHandler() {
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.EXECUTE;
        }

        @Override
        public void invoke(WorkflowStub untyped, Method method, Object[] args) {
            WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
            if (workflowMethod == null) {
                throw new IllegalArgumentException("WorkflowClient.execute can be called only on a method annotated with @WorkflowMethod");
            }
            WorkflowInvocationHandler.startWorkflow(untyped, args);
            this.result = untyped.getResultAsync(method.getReturnType(), method.getGenericReturnType());
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            return (R)this.result;
        }
    }

    private static class SyncWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private Object result;

        private SyncWorkflowInvocationHandler() {
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.SYNC;
        }

        @Override
        public void invoke(WorkflowStub untyped, Method method, Object[] args) {
            WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
            QueryMethod queryMethod = method.getAnnotation(QueryMethod.class);
            SignalMethod signalMethod = method.getAnnotation(SignalMethod.class);
            WorkflowInvocationHandler.checkAnnotations(method, workflowMethod, queryMethod, signalMethod);
            if (workflowMethod != null) {
                this.result = this.startWorkflow(untyped, method, args);
            } else if (queryMethod != null) {
                this.result = this.queryWorkflow(untyped, method, queryMethod, args);
            } else if (signalMethod != null) {
                this.signalWorkflow(untyped, method, signalMethod, args);
                this.result = null;
            } else {
                throw new IllegalArgumentException(method + " is not annotated with @WorkflowMethod or @QueryMethod");
            }
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            return (R)this.result;
        }

        private void signalWorkflow(WorkflowStub untyped, Method method, SignalMethod signalMethod, Object[] args) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("Signal method must have void return type: " + method);
            }
            String signalName = WorkflowInvocationHandler.nameFromMethodAndAnnotation(method, signalMethod.name());
            untyped.signal(signalName, args);
        }

        private Object queryWorkflow(WorkflowStub untyped, Method method, QueryMethod queryMethod, Object[] args) {
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Query method cannot have void return type: " + method);
            }
            String queryType = WorkflowInvocationHandler.nameFromMethodAndAnnotation(method, queryMethod.name());
            return untyped.query(queryType, method.getReturnType(), method.getGenericReturnType(), args);
        }

        private Object startWorkflow(WorkflowStub untyped, Method method, Object[] args) {
            WorkflowInvocationHandler.startWorkflow(untyped, args);
            return untyped.getResult(method.getReturnType(), method.getGenericReturnType());
        }
    }

    private static class StartWorkflowInvocationHandler
    implements SpecificInvocationHandler {
        private Object result;

        private StartWorkflowInvocationHandler() {
        }

        @Override
        public InvocationType getInvocationType() {
            return InvocationType.START;
        }

        @Override
        public void invoke(WorkflowStub untyped, Method method, Object[] args) {
            WorkflowMethod workflowMethod = method.getAnnotation(WorkflowMethod.class);
            if (workflowMethod == null) {
                throw new IllegalArgumentException("WorkflowClient.start can be called only on a method annotated with @WorkflowMethod");
            }
            this.result = untyped.start(args);
        }

        @Override
        public <R> R getResult(Class<R> resultClass) {
            return (R)this.result;
        }
    }

    static interface SpecificInvocationHandler {
        public InvocationType getInvocationType();

        public void invoke(WorkflowStub var1, Method var2, Object[] var3) throws Throwable;

        public <R> R getResult(Class<R> var1);
    }

    public static enum InvocationType {
        SYNC,
        START,
        EXECUTE,
        SIGNAL_WITH_START;

    }
}

