/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.internal.sync.AsyncInternal;
import com.uber.cadence.workflow.CancelExternalWorkflowException;
import com.uber.cadence.workflow.ExternalWorkflowStub;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.SignalExternalWorkflowException;
import com.uber.cadence.workflow.SignalOptions;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.util.Objects;

class ExternalWorkflowStubImpl
implements ExternalWorkflowStub {
    private final WorkflowInterceptor decisionContext;
    private final WorkflowExecution execution;

    public ExternalWorkflowStubImpl(WorkflowExecution execution, WorkflowInterceptor decisionContext) {
        this.decisionContext = Objects.requireNonNull(decisionContext);
        this.execution = Objects.requireNonNull(execution);
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution;
    }

    @Override
    public void signal(String signalName, Object ... args) {
        Promise<Void> signaled = this.decisionContext.signalExternalWorkflow(this.execution, signalName, args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(signaled);
            return;
        }
        try {
            signaled.get();
        }
        catch (SignalExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public void signal(SignalOptions signalOptions, Object ... args) {
        Promise<Void> signaled = this.decisionContext.signalExternalWorkflow(signalOptions.getDomain(), this.execution, signalOptions.getSignalName(), args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(signaled);
            return;
        }
        try {
            signaled.get();
        }
        catch (SignalExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public void cancel() {
        Promise<Void> cancelRequested = this.decisionContext.cancelWorkflow(this.execution);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(cancelRequested);
            return;
        }
        try {
            cancelRequested.get();
        }
        catch (CancelExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }
}

