/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.google.common.base.Defaults;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.internal.sync.AsyncInternal;
import com.uber.cadence.workflow.ChildWorkflowException;
import com.uber.cadence.workflow.ChildWorkflowOptions;
import com.uber.cadence.workflow.ChildWorkflowStub;
import com.uber.cadence.workflow.CompletablePromise;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.SignalExternalWorkflowException;
import com.uber.cadence.workflow.SignalOptions;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.lang.reflect.Type;
import java.util.Objects;

class ChildWorkflowStubImpl
implements ChildWorkflowStub {
    private final String workflowType;
    private final ChildWorkflowOptions options;
    private final WorkflowInterceptor decisionContext;
    private final CompletablePromise<WorkflowExecution> execution;

    ChildWorkflowStubImpl(String workflowType, ChildWorkflowOptions options, WorkflowInterceptor decisionContext) {
        this.workflowType = Objects.requireNonNull(workflowType);
        this.options = new ChildWorkflowOptions.Builder(options).validateAndBuildWithDefaults();
        this.decisionContext = Objects.requireNonNull(decisionContext);
        this.execution = Workflow.newPromise();
    }

    @Override
    public String getWorkflowType() {
        return this.workflowType;
    }

    @Override
    public Promise<WorkflowExecution> getExecution() {
        return this.execution;
    }

    @Override
    public ChildWorkflowOptions getOptions() {
        return this.options;
    }

    @Override
    public <R> R execute(Class<R> resultClass, Object ... args) {
        return this.execute(resultClass, resultClass, args);
    }

    @Override
    public <R> R execute(Class<R> resultClass, Type resultType, Object ... args) {
        Promise<R> result = this.executeAsync(resultClass, resultType, args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return (R)Defaults.defaultValue(resultClass);
        }
        try {
            return result.get();
        }
        catch (ChildWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public <R> Promise<R> executeAsync(Class<R> resultClass, Object ... args) {
        return this.executeAsync(resultClass, resultClass, args);
    }

    @Override
    public <R> Promise<R> executeAsync(Class<R> resultClass, Type resultType, Object ... args) {
        WorkflowInterceptor.WorkflowResult<R> result = this.decisionContext.executeChildWorkflow(this.workflowType, resultClass, resultType, args, this.options);
        this.execution.completeFrom(result.getWorkflowExecution());
        return result.getResult();
    }

    @Override
    public void signal(String signalName, Object ... args) {
        Promise<Void> signaled = this.decisionContext.signalExternalWorkflow((WorkflowExecution)this.execution.get(), signalName, args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(signaled);
            return;
        }
        try {
            signaled.get();
        }
        catch (SignalExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public void signal(SignalOptions signalOptions, Object ... args) {
        Promise<Void> signaled = this.decisionContext.signalExternalWorkflow(signalOptions.getDomain(), (WorkflowExecution)this.execution.get(), signalOptions.getSignalName(), args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(signaled);
            return;
        }
        try {
            signaled.get();
        }
        catch (SignalExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }
}

