/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.sync;

import com.uber.cadence.activity.ActivityMethod;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.common.MethodRetry;
import com.uber.cadence.internal.sync.ActivityInvocationHandlerBase;
import com.uber.cadence.internal.sync.ActivityStubImpl;
import com.uber.cadence.workflow.ActivityStub;
import com.uber.cadence.workflow.WorkflowInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Function;

class ActivityInvocationHandler
extends ActivityInvocationHandlerBase {
    private final ActivityOptions options;
    private final WorkflowInterceptor activityExecutor;

    static InvocationHandler newInstance(ActivityOptions options, WorkflowInterceptor activityExecutor) {
        return new ActivityInvocationHandler(options, activityExecutor);
    }

    private ActivityInvocationHandler(ActivityOptions options, WorkflowInterceptor activityExecutor) {
        this.options = options;
        this.activityExecutor = activityExecutor;
    }

    @Override
    protected Function<Object[], Object> getActivityFunc(Method method, MethodRetry methodRetry, ActivityMethod activityMethod, String activityName) {
        ActivityOptions mergedOptions = ActivityOptions.merge(activityMethod, methodRetry, this.options);
        ActivityStub stub = ActivityStubImpl.newInstance(mergedOptions, this.activityExecutor);
        Function<Object[], Object> function = a -> stub.execute(activityName, method.getReturnType(), method.getGenericReturnType(), a);
        return function;
    }
}

