/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.ParentClosePolicy;
import com.uber.cadence.WorkflowIdReusePolicy;
import com.uber.cadence.WorkflowType;
import com.uber.cadence.internal.common.RetryParameters;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class StartChildWorkflowExecutionParameters {
    private final String domain;
    private final String control;
    private final long executionStartToCloseTimeoutSeconds;
    private final byte[] input;
    private final String taskList;
    private final long taskStartToCloseTimeoutSeconds;
    private final String workflowId;
    private final WorkflowType workflowType;
    private final WorkflowIdReusePolicy workflowIdReusePolicy;
    private final RetryParameters retryParameters;
    private final String cronSchedule;
    private Map<String, Object> memo;
    private Map<String, Object> searchAttributes;
    private Map<String, byte[]> context;
    private final ParentClosePolicy parentClosePolicy;

    private StartChildWorkflowExecutionParameters(String domain, byte[] input, String control, long executionStartToCloseTimeoutSeconds, String taskList, long taskStartToCloseTimeoutSeconds, String workflowId, WorkflowType workflowType, WorkflowIdReusePolicy workflowIdReusePolicy, RetryParameters retryParameters, String cronSchedule, Map<String, Object> memo, Map<String, Object> searchAttributes, Map<String, byte[]> context, ParentClosePolicy parentClosePolicy) {
        this.domain = domain;
        this.input = input;
        this.control = control;
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
        this.taskList = taskList;
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
        this.workflowId = workflowId;
        this.workflowType = workflowType;
        this.workflowIdReusePolicy = workflowIdReusePolicy;
        this.retryParameters = retryParameters;
        this.cronSchedule = cronSchedule;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.context = context;
        this.parentClosePolicy = parentClosePolicy;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getControl() {
        return this.control;
    }

    public long getExecutionStartToCloseTimeoutSeconds() {
        return this.executionStartToCloseTimeoutSeconds;
    }

    public byte[] getInput() {
        return this.input;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public long getTaskStartToCloseTimeoutSeconds() {
        return this.taskStartToCloseTimeoutSeconds;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public WorkflowIdReusePolicy getWorkflowIdReusePolicy() {
        return this.workflowIdReusePolicy;
    }

    public RetryParameters getRetryParameters() {
        return this.retryParameters;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public Map<String, Object> getMemo() {
        return this.memo;
    }

    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    public Map<String, byte[]> getContext() {
        return this.context;
    }

    public ParentClosePolicy getParentClosePolicy() {
        return this.parentClosePolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartChildWorkflowExecutionParameters that = (StartChildWorkflowExecutionParameters)o;
        return this.executionStartToCloseTimeoutSeconds == that.executionStartToCloseTimeoutSeconds && this.taskStartToCloseTimeoutSeconds == that.taskStartToCloseTimeoutSeconds && Objects.equals(this.domain, that.domain) && Objects.equals(this.control, that.control) && Arrays.equals(this.input, that.input) && Objects.equals(this.taskList, that.taskList) && Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.workflowType, that.workflowType) && this.workflowIdReusePolicy == that.workflowIdReusePolicy && Objects.equals(this.retryParameters, that.retryParameters) && Objects.equals(this.cronSchedule, that.cronSchedule) && Objects.equals(this.memo, that.memo) && Objects.equals(this.searchAttributes, that.searchAttributes) && Objects.equals(this.context, that.context) && Objects.equals((Object)this.parentClosePolicy, (Object)that.parentClosePolicy);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.domain, this.control, this.executionStartToCloseTimeoutSeconds, this.taskList, this.taskStartToCloseTimeoutSeconds, this.workflowId, this.workflowType, this.workflowIdReusePolicy, this.retryParameters, this.cronSchedule, this.memo, this.searchAttributes, this.context, this.parentClosePolicy});
        result = 31 * result + Arrays.hashCode(this.input);
        return result;
    }

    public String toString() {
        return "StartChildWorkflowExecutionParameters{domain='" + this.domain + '\'' + ", control='" + this.control + '\'' + ", executionStartToCloseTimeoutSeconds=" + this.executionStartToCloseTimeoutSeconds + ", input=" + Arrays.toString(this.input) + ", taskList='" + this.taskList + '\'' + ", taskStartToCloseTimeoutSeconds=" + this.taskStartToCloseTimeoutSeconds + ", workflowId='" + this.workflowId + '\'' + ", workflowType=" + this.workflowType + ", workflowIdReusePolicy=" + (Object)((Object)this.workflowIdReusePolicy) + ", retryParameters=" + this.retryParameters + ", cronSchedule=" + this.cronSchedule + ", memo=" + this.memo + ", searchAttributes=" + this.searchAttributes + ", context='" + this.context + ", parentClosePolicy=" + (Object)((Object)this.parentClosePolicy) + '}';
    }

    public static final class Builder {
        private String domain;
        private String control;
        private long executionStartToCloseTimeoutSeconds;
        private byte[] input;
        private String taskList;
        private long taskStartToCloseTimeoutSeconds;
        private String workflowId;
        private WorkflowType workflowType;
        private WorkflowIdReusePolicy workflowIdReusePolicy;
        private RetryParameters retryParameters;
        private String cronSchedule;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;
        private Map<String, byte[]> context;
        private ParentClosePolicy parentClosePolicy;

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setControl(String control) {
            this.control = control;
            return this;
        }

        public Builder setExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
            this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
            return this;
        }

        public Builder setInput(byte[] input) {
            this.input = input;
            return this;
        }

        public Builder setTaskList(String taskList) {
            this.taskList = taskList;
            return this;
        }

        public Builder setTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
            this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
            return this;
        }

        public Builder setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder setWorkflowType(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public Builder setWorkflowIdReusePolicy(WorkflowIdReusePolicy workflowIdReusePolicy) {
            this.workflowIdReusePolicy = workflowIdReusePolicy;
            return this;
        }

        public Builder setRetryParameters(RetryParameters retryParameters) {
            this.retryParameters = retryParameters;
            return this;
        }

        public Builder setCronSchedule(String cronSchedule) {
            this.cronSchedule = cronSchedule;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setContext(Map<String, byte[]> context) {
            this.context = context;
            return this;
        }

        public Builder setParentClosePolicy(ParentClosePolicy parentClosePolicy) {
            this.parentClosePolicy = parentClosePolicy;
            return this;
        }

        public StartChildWorkflowExecutionParameters build() {
            return new StartChildWorkflowExecutionParameters(this.domain, this.input, this.control, this.executionStartToCloseTimeoutSeconds, this.taskList, this.taskStartToCloseTimeoutSeconds, this.workflowId, this.workflowType, this.workflowIdReusePolicy, this.retryParameters, this.cronSchedule, this.memo, this.searchAttributes, this.context, this.parentClosePolicy);
        }
    }
}

