/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.replay;

import com.uber.cadence.EventType;
import com.uber.cadence.Header;
import com.uber.cadence.HistoryEvent;
import com.uber.cadence.MarkerRecordedEventAttributes;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.internal.replay.DecisionsHelper;
import com.uber.cadence.internal.replay.ReplayAware;
import com.uber.cadence.workflow.Functions;
import com.uber.m3.util.ImmutableMap;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.thrift.TBaseHelper;

class MarkerHandler {
    private static final String MUTABLE_MARKER_HEADER_KEY = "MutableMarkerHeader";
    private final DecisionsHelper decisions;
    private final String markerName;
    private final ReplayAware replayContext;
    private final Map<String, MarkerResult> mutableMarkerResults = new HashMap<String, MarkerResult>();

    MarkerHandler(DecisionsHelper decisions, String markerName, ReplayAware replayContext) {
        this.decisions = decisions;
        this.markerName = markerName;
        this.replayContext = replayContext;
    }

    HandleResult handle(String id, DataConverter converter, Functions.Func1<Optional<byte[]>, Optional<byte[]>> func) {
        int accessCount;
        MarkerResult result = this.mutableMarkerResults.get(id);
        Optional<Object> stored = result == null ? Optional.empty() : Optional.of(result.getData());
        long eventId = this.decisions.getNextDecisionEventId();
        int n = accessCount = result == null ? 0 : result.getAccessCount();
        if (this.replayContext.isReplaying()) {
            Optional<byte[]> data = this.getMarkerDataFromHistory(eventId, id, accessCount, converter);
            if (data.isPresent()) {
                this.recordMutableMarker(id, eventId, data.get(), accessCount, converter);
                this.decisions.addPossibleMissingDecisionForChangeVersionSearchAttribute();
                return new HandleResult(data, false);
            }
            if (!stored.isPresent()) {
                this.mutableMarkerResults.put(id, new MarkerResult(converter.toData(-1)));
            }
            return new HandleResult(stored, false);
        }
        Optional<byte[]> toStore = func.apply(stored);
        if (toStore.isPresent()) {
            byte[] data = toStore.get();
            this.recordMutableMarker(id, eventId, data, accessCount, converter);
            return new HandleResult(toStore, true);
        }
        return new HandleResult(stored, false);
    }

    private Optional<byte[]> getMarkerDataFromHistory(long eventId, String markerId, int expectedAcccessCount, DataConverter converter) {
        Optional<HistoryEvent> event = this.decisions.getOptionalDecisionEvent(eventId);
        if (!event.isPresent() || event.get().getEventType() != EventType.MarkerRecorded) {
            return Optional.empty();
        }
        MarkerRecordedEventAttributes attributes = event.get().getMarkerRecordedEventAttributes();
        String name = attributes.getMarkerName();
        if (!this.markerName.equals(name)) {
            return Optional.empty();
        }
        MarkerInterface markerData = MarkerInterface.fromEventAttributes(attributes, converter);
        if (!markerId.equals(markerData.getId()) || markerData.getAccessCount() > expectedAcccessCount) {
            return Optional.empty();
        }
        return Optional.of(markerData.getData());
    }

    private void recordMutableMarker(String id, long eventId, byte[] data, int accessCount, DataConverter converter) {
        MarkerData marker = new MarkerData(id, eventId, data, accessCount);
        this.mutableMarkerResults.put(id, new MarkerResult(data));
        this.decisions.recordMarker(this.markerName, marker.getHeader(converter), data);
    }

    static final class HandleResult {
        private Optional<byte[]> storedData;
        private boolean isNewlyStored;

        HandleResult(Optional<byte[]> storedData, boolean isNewlyStored) {
            this.storedData = storedData;
            this.isNewlyStored = isNewlyStored;
        }

        public boolean isNewlyStored() {
            return this.isNewlyStored;
        }

        public Optional<byte[]> getStoredData() {
            return this.storedData;
        }
    }

    static final class PlainMarkerData
    implements MarkerInterface {
        private final String id;
        private final long eventId;
        private final byte[] data;
        private final int accessCount;

        PlainMarkerData(String id, long eventId, byte[] data, int accessCount) {
            this.id = id;
            this.eventId = eventId;
            this.data = data;
            this.accessCount = accessCount;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public long getEventId() {
            return this.eventId;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public int getAccessCount() {
            return this.accessCount;
        }
    }

    static final class MarkerData
    implements MarkerInterface {
        private final MarkerHeader header;
        private final byte[] data;

        MarkerData(String id, long eventId, byte[] data, int accessCount) {
            this.header = new MarkerHeader(id, eventId, accessCount);
            this.data = data;
        }

        MarkerData(MarkerHeader header, byte[] data) {
            this.header = header;
            this.data = data;
        }

        @Override
        public String getId() {
            return this.header.id;
        }

        @Override
        public long getEventId() {
            return this.header.eventId;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public int getAccessCount() {
            return this.header.accessCount;
        }

        Header getHeader(DataConverter converter) {
            byte[] headerData = converter.toData(this.header);
            Header header = new Header();
            header.setFields((Map<String, ByteBuffer>)ImmutableMap.of((Object)MarkerHandler.MUTABLE_MARKER_HEADER_KEY, (Object)ByteBuffer.wrap(headerData)));
            return header;
        }

        private static final class MarkerHeader {
            private final String id;
            private final long eventId;
            private final int accessCount;

            MarkerHeader(String id, long eventId, int accessCount) {
                this.id = id;
                this.eventId = eventId;
                this.accessCount = accessCount;
            }
        }
    }

    static interface MarkerInterface {
        public String getId();

        public long getEventId();

        public int getAccessCount();

        public byte[] getData();

        public static MarkerInterface fromEventAttributes(MarkerRecordedEventAttributes attributes, DataConverter converter) {
            if (attributes.getHeader() != null && attributes.getHeader().getFields() != null && attributes.getHeader().getFields().containsKey(MarkerHandler.MUTABLE_MARKER_HEADER_KEY)) {
                ByteBuffer byteBuffer = attributes.getHeader().getFields().get(MarkerHandler.MUTABLE_MARKER_HEADER_KEY);
                byte[] bytes = TBaseHelper.byteBufferToByteArray((ByteBuffer)byteBuffer);
                MarkerData.MarkerHeader header = converter.fromData(bytes, MarkerData.MarkerHeader.class, (Type)((Object)MarkerData.MarkerHeader.class));
                return new MarkerData(header, attributes.getDetails());
            }
            return converter.fromData(attributes.getDetails(), PlainMarkerData.class, (Type)((Object)PlainMarkerData.class));
        }
    }

    private static final class MarkerResult {
        private final byte[] data;
        private int accessCount;

        private MarkerResult(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            ++this.accessCount;
            return this.data;
        }

        int getAccessCount() {
            return this.accessCount;
        }
    }
}

