/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.metrics;

import com.uber.cadence.internal.Version;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientVersionEmitter
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientVersionEmitter.class);
    private Scope metricScope;

    public ClientVersionEmitter(Scope metricScope, String domain) {
        if (domain == null) {
            domain = "UNKNOWN";
        }
        Properties prop = new Properties();
        InputStream in = Version.class.getResourceAsStream("/com/uber/cadence/version.properties");
        String version = "UNKNOWN";
        if (in != null) {
            try {
                prop.load(in);
                version = prop.getProperty("cadence-client-version");
            }
            catch (IOException exception) {
                LOGGER.warn("couldn't read java cadence-client-version");
            }
        }
        ImmutableMap tags = new ImmutableMap.Builder(2).put((Object)"Version", (Object)version).put((Object)"Domain", (Object)domain).build();
        this.metricScope = metricScope == null ? NoopScope.getInstance() : metricScope.tagged((Map)tags);
    }

    @Override
    public void run() {
        this.metricScope.counter("cadence-java-client-version").inc(1L);
    }
}

