/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.internal.compatibility.proto;

import com.uber.cadence.CancelTimerDecisionAttributes;
import com.uber.cadence.CancelWorkflowExecutionDecisionAttributes;
import com.uber.cadence.CompleteWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.uber.cadence.Decision;
import com.uber.cadence.FailWorkflowExecutionDecisionAttributes;
import com.uber.cadence.RecordMarkerDecisionAttributes;
import com.uber.cadence.RequestCancelActivityTaskDecisionAttributes;
import com.uber.cadence.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.StartTimerDecisionAttributes;
import com.uber.cadence.UpsertWorkflowSearchAttributesDecisionAttributes;
import com.uber.cadence.api.v1.ContinueAsNewWorkflowExecutionDecisionAttributes;
import com.uber.cadence.api.v1.Decision;
import com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.api.v1.ScheduleActivityTaskDecisionAttributes;
import com.uber.cadence.api.v1.SignalExternalWorkflowExecutionDecisionAttributes;
import com.uber.cadence.api.v1.StartChildWorkflowExecutionDecisionAttributes;
import com.uber.cadence.internal.compatibility.proto.EnumMapper;
import com.uber.cadence.internal.compatibility.proto.Helpers;
import com.uber.cadence.internal.compatibility.proto.TypeMapper;
import java.util.ArrayList;
import java.util.List;

class DecisionMapper {
    DecisionMapper() {
    }

    static List<com.uber.cadence.api.v1.Decision> decisionArray(List<Decision> t) {
        if (t == null) {
            return null;
        }
        ArrayList<com.uber.cadence.api.v1.Decision> v = new ArrayList<com.uber.cadence.api.v1.Decision>();
        for (int i = 0; i < t.size(); ++i) {
            v.add(DecisionMapper.decision(t.get(i)));
        }
        return v;
    }

    static com.uber.cadence.api.v1.Decision decision(Decision d) {
        if (d == null) {
            return null;
        }
        Decision.Builder decision = com.uber.cadence.api.v1.Decision.newBuilder();
        switch (d.getDecisionType()) {
            case ScheduleActivityTask: {
                ScheduleActivityTaskDecisionAttributes attr = d.getScheduleActivityTaskDecisionAttributes();
                ScheduleActivityTaskDecisionAttributes.Builder builder = com.uber.cadence.api.v1.ScheduleActivityTaskDecisionAttributes.newBuilder().setActivityId(attr.getActivityId()).setActivityType(TypeMapper.activityType(attr.getActivityType())).setTaskList(TypeMapper.taskList(attr.getTaskList())).setInput(TypeMapper.payload(attr.getInput())).setScheduleToCloseTimeout(Helpers.secondsToDuration(attr.getScheduleToCloseTimeoutSeconds())).setScheduleToStartTimeout(Helpers.secondsToDuration(attr.getScheduleToStartTimeoutSeconds())).setStartToCloseTimeout(Helpers.secondsToDuration(attr.getStartToCloseTimeoutSeconds())).setHeartbeatTimeout(Helpers.secondsToDuration(attr.getHeartbeatTimeoutSeconds())).setHeader(TypeMapper.header(attr.getHeader())).setRequestLocalDispatch(attr.isRequestLocalDispatch());
                if (attr.getRetryPolicy() != null) {
                    builder.setRetryPolicy(TypeMapper.retryPolicy(attr.getRetryPolicy()));
                }
                if (attr.getDomain() != null) {
                    builder.setDomain(attr.getDomain());
                }
                decision.setScheduleActivityTaskDecisionAttributes(builder);
                break;
            }
            case RequestCancelActivityTask: {
                RequestCancelActivityTaskDecisionAttributes attr = d.getRequestCancelActivityTaskDecisionAttributes();
                decision.setRequestCancelActivityTaskDecisionAttributes(com.uber.cadence.api.v1.RequestCancelActivityTaskDecisionAttributes.newBuilder().setActivityId(attr.getActivityId()));
                break;
            }
            case StartTimer: {
                StartTimerDecisionAttributes attr = d.getStartTimerDecisionAttributes();
                decision.setStartTimerDecisionAttributes(com.uber.cadence.api.v1.StartTimerDecisionAttributes.newBuilder().setTimerId(attr.getTimerId()).setStartToFireTimeout(Helpers.secondsToDuration(Helpers.longToInt(attr.getStartToFireTimeoutSeconds()))));
                break;
            }
            case CompleteWorkflowExecution: {
                CompleteWorkflowExecutionDecisionAttributes attr = d.getCompleteWorkflowExecutionDecisionAttributes();
                decision.setCompleteWorkflowExecutionDecisionAttributes(com.uber.cadence.api.v1.CompleteWorkflowExecutionDecisionAttributes.newBuilder().setResult(TypeMapper.payload(attr.getResult())));
                break;
            }
            case FailWorkflowExecution: {
                FailWorkflowExecutionDecisionAttributes attr = d.getFailWorkflowExecutionDecisionAttributes();
                decision.setFailWorkflowExecutionDecisionAttributes(com.uber.cadence.api.v1.FailWorkflowExecutionDecisionAttributes.newBuilder().setFailure(TypeMapper.failure(attr.getReason(), attr.getDetails())));
                break;
            }
            case CancelTimer: {
                CancelTimerDecisionAttributes attr = d.getCancelTimerDecisionAttributes();
                decision.setCancelTimerDecisionAttributes(com.uber.cadence.api.v1.CancelTimerDecisionAttributes.newBuilder().setTimerId(attr.getTimerId()));
                break;
            }
            case CancelWorkflowExecution: {
                CancelWorkflowExecutionDecisionAttributes attr = d.getCancelWorkflowExecutionDecisionAttributes();
                decision.setCancelWorkflowExecutionDecisionAttributes(com.uber.cadence.api.v1.CancelWorkflowExecutionDecisionAttributes.newBuilder().setDetails(TypeMapper.payload(attr.getDetails())));
                break;
            }
            case RequestCancelExternalWorkflowExecution: {
                RequestCancelExternalWorkflowExecutionDecisionAttributes attr = d.getRequestCancelExternalWorkflowExecutionDecisionAttributes();
                RequestCancelExternalWorkflowExecutionDecisionAttributes.Builder builder = com.uber.cadence.api.v1.RequestCancelExternalWorkflowExecutionDecisionAttributes.newBuilder().setDomain(attr.getDomain()).setWorkflowExecution(TypeMapper.workflowRunPair(attr.getWorkflowId(), attr.getRunId())).setChildWorkflowOnly(attr.isChildWorkflowOnly());
                if (attr.getControl() != null) {
                    builder.setControl(Helpers.arrayToByteString(attr.getControl()));
                }
                decision.setRequestCancelExternalWorkflowExecutionDecisionAttributes(builder);
                break;
            }
            case ContinueAsNewWorkflowExecution: {
                ContinueAsNewWorkflowExecutionDecisionAttributes attr = d.getContinueAsNewWorkflowExecutionDecisionAttributes();
                ContinueAsNewWorkflowExecutionDecisionAttributes.Builder builder = com.uber.cadence.api.v1.ContinueAsNewWorkflowExecutionDecisionAttributes.newBuilder().setWorkflowType(TypeMapper.workflowType(attr.getWorkflowType())).setTaskList(TypeMapper.taskList(attr.getTaskList())).setInput(TypeMapper.payload(attr.getInput())).setExecutionStartToCloseTimeout(Helpers.secondsToDuration(attr.getExecutionStartToCloseTimeoutSeconds())).setTaskStartToCloseTimeout(Helpers.secondsToDuration(attr.getTaskStartToCloseTimeoutSeconds())).setBackoffStartInterval(Helpers.secondsToDuration(attr.getBackoffStartIntervalInSeconds())).setInitiator(EnumMapper.continueAsNewInitiator(attr.getInitiator())).setFailure(TypeMapper.failure(attr.getFailureReason(), attr.getFailureDetails())).setLastCompletionResult(TypeMapper.payload(attr.getLastCompletionResult())).setHeader(TypeMapper.header(attr.getHeader())).setMemo(TypeMapper.memo(attr.getMemo())).setSearchAttributes(TypeMapper.searchAttributes(attr.getSearchAttributes()));
                if (attr.getRetryPolicy() != null) {
                    builder.setRetryPolicy(TypeMapper.retryPolicy(attr.getRetryPolicy()));
                }
                if (attr.getCronSchedule() != null) {
                    builder.setCronSchedule(attr.getCronSchedule());
                }
                decision.setContinueAsNewWorkflowExecutionDecisionAttributes(builder);
                break;
            }
            case StartChildWorkflowExecution: {
                StartChildWorkflowExecutionDecisionAttributes attr = d.getStartChildWorkflowExecutionDecisionAttributes();
                StartChildWorkflowExecutionDecisionAttributes.Builder builder = com.uber.cadence.api.v1.StartChildWorkflowExecutionDecisionAttributes.newBuilder().setDomain(attr.getDomain()).setWorkflowId(attr.getWorkflowId()).setWorkflowType(TypeMapper.workflowType(attr.getWorkflowType())).setTaskList(TypeMapper.taskList(attr.getTaskList())).setInput(TypeMapper.payload(attr.getInput())).setExecutionStartToCloseTimeout(Helpers.secondsToDuration(attr.getExecutionStartToCloseTimeoutSeconds())).setTaskStartToCloseTimeout(Helpers.secondsToDuration(attr.getTaskStartToCloseTimeoutSeconds())).setParentClosePolicy(EnumMapper.parentClosePolicy(attr.getParentClosePolicy())).setWorkflowIdReusePolicy(EnumMapper.workflowIdReusePolicy(attr.getWorkflowIdReusePolicy())).setHeader(TypeMapper.header(attr.getHeader())).setMemo(TypeMapper.memo(attr.getMemo())).setSearchAttributes(TypeMapper.searchAttributes(attr.getSearchAttributes()));
                if (attr.getRetryPolicy() != null) {
                    builder.setRetryPolicy(TypeMapper.retryPolicy(attr.getRetryPolicy()));
                }
                if (attr.getControl() != null) {
                    builder.setControl(Helpers.arrayToByteString(attr.getControl()));
                }
                if (attr.getCronSchedule() != null) {
                    builder.setCronSchedule(attr.getCronSchedule());
                }
                decision.setStartChildWorkflowExecutionDecisionAttributes(builder);
                break;
            }
            case SignalExternalWorkflowExecution: {
                SignalExternalWorkflowExecutionDecisionAttributes attr = d.getSignalExternalWorkflowExecutionDecisionAttributes();
                SignalExternalWorkflowExecutionDecisionAttributes.Builder builder = com.uber.cadence.api.v1.SignalExternalWorkflowExecutionDecisionAttributes.newBuilder().setDomain(attr.getDomain()).setWorkflowExecution(TypeMapper.workflowExecution(attr.getExecution())).setSignalName(attr.getSignalName()).setInput(TypeMapper.payload(attr.getInput())).setChildWorkflowOnly(attr.isChildWorkflowOnly());
                if (attr.getControl() != null) {
                    builder.setControl(Helpers.arrayToByteString(attr.getControl()));
                }
                decision.setSignalExternalWorkflowExecutionDecisionAttributes(builder);
                break;
            }
            case UpsertWorkflowSearchAttributes: {
                UpsertWorkflowSearchAttributesDecisionAttributes attr = d.getUpsertWorkflowSearchAttributesDecisionAttributes();
                decision.setUpsertWorkflowSearchAttributesDecisionAttributes(com.uber.cadence.api.v1.UpsertWorkflowSearchAttributesDecisionAttributes.newBuilder().setSearchAttributes(TypeMapper.searchAttributes(attr.getSearchAttributes())));
                break;
            }
            case RecordMarker: {
                RecordMarkerDecisionAttributes attr = d.getRecordMarkerDecisionAttributes();
                decision.setRecordMarkerDecisionAttributes(com.uber.cadence.api.v1.RecordMarkerDecisionAttributes.newBuilder().setMarkerName(attr.getMarkerName()).setDetails(TypeMapper.payload(attr.getDetails())).setHeader(TypeMapper.header(attr.getHeader())));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown decision type");
            }
        }
        return decision.build();
    }
}

