/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.converter;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.uber.cadence.converter.DataConverterException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomThrowableTypeAdapter<T extends Throwable>
extends TypeAdapter<T> {
    private static final Logger log = LoggerFactory.getLogger(CustomThrowableTypeAdapter.class);
    private static final String TRACE_ELEMENT_REGEXP = "((?<className>.*)\\.(?<methodName>.*))\\(((?<fileName>.*?)(:(?<lineNumber>\\d+))?)\\)";
    private static final Pattern TRACE_ELEMENT_PATTERN = Pattern.compile("((?<className>.*)\\.(?<methodName>.*))\\(((?<fileName>.*?)(:(?<lineNumber>\\d+))?)\\)");
    private static final ImmutableSet<String> CUTOFF_METHOD_NAMES = ImmutableSet.of((Object)"com.uber.cadence.internal.worker.POJOActivityImplementationFactory$POJOActivityImplementation.execute", (Object)"com.uber.cadence.internal.sync.POJODecisionTaskHandler$POJOWorkflowImplementation.execute");
    private final Gson gson;
    private final TypeAdapterFactory skipPast;

    CustomThrowableTypeAdapter(Gson gson, TypeAdapterFactory skipPast) {
        this.gson = gson;
        this.skipPast = skipPast;
    }

    public void write(JsonWriter jsonWriter, T throwable) throws IOException {
        JsonObject object;
        StackTraceElement[] trace;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement element : trace = ((Throwable)throwable).getStackTrace()) {
            pw.println(element);
            String fullMethodName = element.getClassName() + "." + element.getMethodName();
            if (CUTOFF_METHOD_NAMES.contains((Object)fullMethodName)) break;
        }
        Throwable cause = null;
        if (((Throwable)throwable).getCause() != null && ((Throwable)throwable).getCause() != throwable) {
            try {
                cause = ((Throwable)throwable).getCause();
                Field causeField = Throwable.class.getDeclaredField("cause");
                causeField.setAccessible(true);
                causeField.set(throwable, null);
            }
            catch (Exception e) {
                log.warn("Failed to clear cause in original throwable.", (Throwable)e);
            }
        }
        try {
            TypeAdapter exceptionTypeAdapter = this.gson.getDelegateAdapter(this.skipPast, TypeToken.get(throwable.getClass()));
            object = exceptionTypeAdapter.toJsonTree(throwable).getAsJsonObject();
            object.add("class", (JsonElement)new JsonPrimitive(throwable.getClass().getName()));
            object.add("stackTrace", (JsonElement)new JsonPrimitive(sw.toString()));
        }
        catch (Throwable e) {
            DataConverterException ee = new DataConverterException("Failure serializing exception: " + ((Throwable)throwable).toString(), e);
            if (cause != null) {
                ee.addSuppressed(cause);
                cause = null;
            }
            CustomThrowableTypeAdapter<T> exceptionTypeAdapter = new CustomThrowableTypeAdapter<T>(this.gson, this.skipPast);
            object = exceptionTypeAdapter.toJsonTree(ee).getAsJsonObject();
        }
        if (cause != null) {
            CustomThrowableTypeAdapter<T> causeTypeAdapter = new CustomThrowableTypeAdapter<T>(this.gson, this.skipPast);
            try {
                object.add("cause", causeTypeAdapter.toJsonTree(cause));
            }
            catch (Throwable e) {
                DataConverterException ee = new DataConverterException("Failure serializing exception: " + cause.toString(), e);
                ee.setStackTrace(cause.getStackTrace());
                object.add("cause", causeTypeAdapter.toJsonTree(ee));
            }
        }
        TypeAdapter elementAdapter = this.gson.getAdapter(JsonElement.class);
        elementAdapter.write(jsonWriter, (Object)object);
    }

    public T read(JsonReader jsonReader) throws IOException {
        TypeAdapter elementAdapter = this.gson.getAdapter(JsonElement.class);
        JsonObject object = ((JsonElement)elementAdapter.read(jsonReader)).getAsJsonObject();
        JsonElement classElement = object.get("class");
        if (classElement != null) {
            Class<?> classType;
            String className = classElement.getAsString();
            try {
                classType = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Cannot deserialize " + className + " exception", e);
            }
            if (!Throwable.class.isAssignableFrom(classType)) {
                throw new IOException("Expected type that extends Throwable: " + className);
            }
            StackTraceElement[] stackTrace = this.parseStackTrace(object);
            object.add("stackTrace", (JsonElement)new JsonArray());
            TypeAdapter exceptionTypeAdapter = this.gson.getDelegateAdapter(this.skipPast, TypeToken.get(classType));
            Throwable result = (Throwable)exceptionTypeAdapter.fromJsonTree((JsonElement)object);
            result.setStackTrace(stackTrace);
            Throwable typedResult = result;
            return (T)typedResult;
        }
        throw new IOException();
    }

    private StackTraceElement[] parseStackTrace(JsonObject object) {
        JsonElement jsonStackTrace = object.get("stackTrace");
        if (jsonStackTrace == null) {
            return new StackTraceElement[0];
        }
        String stackTrace = jsonStackTrace.getAsString();
        if (stackTrace == null || stackTrace.isEmpty()) {
            return new StackTraceElement[0];
        }
        try {
            String[] lines = stackTrace.split("\r\n|\n");
            StackTraceElement[] result = new StackTraceElement[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                result[i] = CustomThrowableTypeAdapter.parseStackTraceElement(lines[i]);
            }
            return result;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Failed to parse stack trace: " + stackTrace);
            }
            return new StackTraceElement[0];
        }
    }

    private static StackTraceElement parseStackTraceElement(String line) {
        Matcher matcher = TRACE_ELEMENT_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String declaringClass = matcher.group("className");
        String methodName = matcher.group("methodName");
        String fileName = matcher.group("fileName");
        int lineNumber = 0;
        String lns = matcher.group("lineNumber");
        if (lns != null && lns.length() > 0) {
            try {
                lineNumber = Integer.parseInt(matcher.group("lineNumber"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }
}

