/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.QueryRejectCondition;
import com.uber.cadence.client.WorkflowClientInterceptor;
import com.uber.cadence.context.ContextPropagator;
import com.uber.cadence.converter.DataConverter;
import com.uber.cadence.converter.JsonDataConverter;
import com.uber.cadence.internal.metrics.NoopScope;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class WorkflowClientOptions {
    private static final String DEFAULT_DOMAIN = "default";
    private static final WorkflowClientOptions DEFAULT_INSTANCE;
    private static final WorkflowClientInterceptor[] EMPTY_INTERCEPTOR_ARRAY;
    private static final List<ContextPropagator> EMPTY_CONTEXT_PROPAGATORS;
    private final String domain;
    private final DataConverter dataConverter;
    private final WorkflowClientInterceptor[] interceptors;
    private final Scope metricsScope;
    private final String identity;
    private final List<ContextPropagator> contextPropagators;
    private final QueryRejectCondition queryRejectCondition;

    public static WorkflowClientOptions defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowClientOptions options) {
        return new Builder(options);
    }

    private WorkflowClientOptions(String domain, DataConverter dataConverter, WorkflowClientInterceptor[] interceptors, Scope metricsScope, String identity, List<ContextPropagator> contextPropagators, QueryRejectCondition queryRejectCondition) {
        this.domain = domain;
        this.dataConverter = dataConverter;
        this.interceptors = interceptors;
        this.metricsScope = metricsScope;
        this.identity = identity;
        this.contextPropagators = contextPropagators;
        this.queryRejectCondition = queryRejectCondition;
    }

    public String getDomain() {
        return this.domain;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public WorkflowClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public String getIdentity() {
        return this.identity;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public QueryRejectCondition getQueryRejectCondition() {
        return this.queryRejectCondition;
    }

    public String toString() {
        return "WorkflowClientOptions{domain='" + this.domain + '\'' + ", dataConverter=" + this.dataConverter + ", interceptors=" + Arrays.toString(this.interceptors) + ", identity='" + this.identity + '\'' + ", contextPropagators=" + this.contextPropagators + ", queryRejectCondition=" + (Object)((Object)this.queryRejectCondition) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowClientOptions that = (WorkflowClientOptions)o;
        return com.google.common.base.Objects.equal((Object)this.domain, (Object)that.domain) && com.google.common.base.Objects.equal((Object)this.dataConverter, (Object)that.dataConverter) && Arrays.equals(this.interceptors, that.interceptors) && com.google.common.base.Objects.equal((Object)this.identity, (Object)that.identity) && com.google.common.base.Objects.equal(this.contextPropagators, that.contextPropagators) && this.queryRejectCondition == that.queryRejectCondition;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.domain, this.dataConverter, Arrays.hashCode(this.interceptors), this.identity, this.contextPropagators, this.queryRejectCondition});
    }

    static /* synthetic */ WorkflowClientInterceptor[] access$200() {
        return EMPTY_INTERCEPTOR_ARRAY;
    }

    static /* synthetic */ List access$300() {
        return EMPTY_CONTEXT_PROPAGATORS;
    }

    static {
        EMPTY_INTERCEPTOR_ARRAY = new WorkflowClientInterceptor[0];
        EMPTY_CONTEXT_PROPAGATORS = Arrays.asList(new ContextPropagator[0]);
        DEFAULT_INSTANCE = new Builder().build();
    }

    public static final class Builder {
        private String domain = "default";
        private DataConverter dataConverter = JsonDataConverter.getInstance();
        private WorkflowClientInterceptor[] interceptors = WorkflowClientOptions.access$200();
        private Scope metricsScope = NoopScope.getInstance();
        private String identity = ManagementFactory.getRuntimeMXBean().getName();
        private List<ContextPropagator> contextPropagators = WorkflowClientOptions.access$300();
        private QueryRejectCondition queryRejectCondition;

        private Builder() {
        }

        private Builder(WorkflowClientOptions options) {
            this.domain = options.getDomain();
            this.dataConverter = options.getDataConverter();
            this.interceptors = options.getInterceptors();
            this.metricsScope = options.getMetricsScope();
            this.identity = options.getIdentity();
            this.queryRejectCondition = options.getQueryRejectCondition();
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = Objects.requireNonNull(dataConverter);
            return this;
        }

        public Builder setInterceptors(WorkflowClientInterceptor ... interceptors) {
            this.interceptors = Objects.requireNonNull(interceptors);
            return this;
        }

        public Builder setMetricsScope(Scope metricsScope) {
            this.metricsScope = Objects.requireNonNull(metricsScope);
            return this;
        }

        public Builder setIdentity(String identity) {
            this.identity = Objects.requireNonNull(identity);
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setQueryRejectCondition(QueryRejectCondition queryRejectCondition) {
            this.queryRejectCondition = queryRejectCondition;
            return this;
        }

        public WorkflowClientOptions build() {
            this.metricsScope = this.metricsScope.tagged((Map)ImmutableMap.of((Object)"Domain", (Object)this.domain));
            return new WorkflowClientOptions(this.domain, this.dataConverter, this.interceptors, this.metricsScope, this.identity, this.contextPropagators, this.queryRejectCondition);
        }
    }
}

