/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cadence.client;

import com.uber.cadence.QueryConsistencyLevel;
import com.uber.cadence.QueryRejectCondition;
import java.util.Objects;

public final class QueryOptions {
    private QueryRejectCondition queryRejectCondition;
    private QueryConsistencyLevel queryConsistencyLevel;

    private QueryOptions(QueryRejectCondition queryRejectCondition, QueryConsistencyLevel queryConsistencyLevel) {
        this.queryConsistencyLevel = queryConsistencyLevel;
        this.queryRejectCondition = queryRejectCondition;
    }

    public QueryRejectCondition getQueryRejectCondition() {
        return this.queryRejectCondition;
    }

    public QueryConsistencyLevel getQueryConsistencyLevel() {
        return this.queryConsistencyLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryOptions that = (QueryOptions)o;
        return Objects.equals((Object)this.queryRejectCondition, (Object)that.queryRejectCondition) && this.queryConsistencyLevel == that.queryConsistencyLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryRejectCondition, this.queryConsistencyLevel});
    }

    public String toString() {
        return "QueryOptions{queryRejectCondition='" + (Object)((Object)this.queryRejectCondition) + '\'' + ", queryConsistencyLevel=" + (Object)((Object)this.queryConsistencyLevel) + '}';
    }

    public static final class Builder {
        private QueryRejectCondition queryRejectCondition = null;
        private QueryConsistencyLevel queryConsistencyLevel = QueryConsistencyLevel.EVENTUAL;

        public Builder() {
        }

        public Builder(QueryOptions o) {
            if (o == null) {
                return;
            }
            this.queryConsistencyLevel = o.queryConsistencyLevel;
            this.queryRejectCondition = o.queryRejectCondition;
        }

        public Builder setQueryRejectCondition(QueryRejectCondition queryRejectCondition) {
            this.queryRejectCondition = queryRejectCondition;
            return this;
        }

        public Builder setQueryConsistencyLevel(QueryConsistencyLevel queryConsistencyLevel) {
            this.queryConsistencyLevel = queryConsistencyLevel;
            return this;
        }

        public QueryOptions build() {
            return new QueryOptions(this.queryRejectCondition, this.queryConsistencyLevel);
        }
    }
}

