/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.lifecycle;

import com.uber.autodispose.AutoDisposePlugins;
import com.uber.autodispose.OutsideScopeException;
import com.uber.autodispose.lifecycle.CorrespondingEventsFunction;
import com.uber.autodispose.lifecycle.LifecycleEndedException;
import com.uber.autodispose.lifecycle.LifecycleNotStartedException;
import com.uber.autodispose.lifecycle.LifecycleScopeProvider;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.annotations.Nullable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import java.util.Comparator;

public final class LifecycleScopes {
    private static final Comparator<Comparable<Object>> COMPARABLE_COMPARATOR = Comparable::compareTo;

    private LifecycleScopes() {
        throw new InstantiationError();
    }

    public static <E> CompletableSource resolveScopeFromLifecycle(LifecycleScopeProvider<E> provider) throws OutsideScopeException {
        return LifecycleScopes.resolveScopeFromLifecycle(provider, true);
    }

    public static <E> CompletableSource resolveScopeFromLifecycle(LifecycleScopeProvider<E> provider, boolean checkEndBoundary) throws OutsideScopeException {
        E endEvent;
        E lastEvent = provider.peekLifecycle();
        CorrespondingEventsFunction<E> eventsFunction = provider.correspondingEvents();
        if (lastEvent == null) {
            throw new LifecycleNotStartedException();
        }
        try {
            endEvent = eventsFunction.apply(lastEvent);
        }
        catch (Exception e) {
            if (checkEndBoundary && e instanceof LifecycleEndedException) {
                Consumer handler = AutoDisposePlugins.getOutsideScopeHandler();
                if (handler != null) {
                    try {
                        handler.accept((Object)((LifecycleEndedException)((Object)e)));
                        return Completable.complete();
                    }
                    catch (Exception e1) {
                        return Completable.error((Throwable)e1);
                    }
                }
                throw e;
            }
            return Completable.error((Throwable)e);
        }
        return LifecycleScopes.resolveScopeFromLifecycle(provider.lifecycle(), endEvent);
    }

    public static <E> CompletableSource resolveScopeFromLifecycle(Observable<E> lifecycle, E endEvent) {
        Comparator<Comparable<Object>> comparator = null;
        if (endEvent instanceof Comparable) {
            comparator = COMPARABLE_COMPARATOR;
        }
        return LifecycleScopes.resolveScopeFromLifecycle(lifecycle, endEvent, comparator);
    }

    public static <E> CompletableSource resolveScopeFromLifecycle(Observable<E> lifecycle, E endEvent, @Nullable Comparator<E> comparator) {
        Predicate equalityPredicate = comparator != null ? e -> comparator.compare(e, endEvent) >= 0 : e -> e.equals(endEvent);
        return lifecycle.skip(1L).takeUntil(equalityPredicate).ignoreElements();
    }
}

